/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AccountStatus;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Money;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Account", propOrder={"identifier", "name", "type", "status", "activePeriod", "currency", "balance", "coveragePeriod", "subject", "owner", "description"})
public class Account
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected String name;
    protected CodeableConcept type;
    protected AccountStatus status;
    protected Period activePeriod;
    protected Coding currency;
    protected Money balance;
    protected Period coveragePeriod;
    protected Reference subject;
    protected Reference owner;
    protected String description;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus value) {
        this.status = value;
    }

    public Period getActivePeriod() {
        return this.activePeriod;
    }

    public void setActivePeriod(Period value) {
        this.activePeriod = value;
    }

    public Coding getCurrency() {
        return this.currency;
    }

    public void setCurrency(Coding value) {
        this.currency = value;
    }

    public Money getBalance() {
        return this.balance;
    }

    public void setBalance(Money value) {
        this.balance = value;
    }

    public Period getCoveragePeriod() {
        return this.coveragePeriod;
    }

    public void setCoveragePeriod(Period value) {
        this.coveragePeriod = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public void setOwner(Reference value) {
        this.owner = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Account withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Account withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Account withName(String value) {
        this.setName(value);
        return this;
    }

    public Account withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Account withStatus(AccountStatus value) {
        this.setStatus(value);
        return this;
    }

    public Account withActivePeriod(Period value) {
        this.setActivePeriod(value);
        return this;
    }

    public Account withCurrency(Coding value) {
        this.setCurrency(value);
        return this;
    }

    public Account withBalance(Money value) {
        this.setBalance(value);
        return this;
    }

    public Account withCoveragePeriod(Period value) {
        this.setCoveragePeriod(value);
        return this;
    }

    public Account withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Account withOwner(Reference value) {
        this.setOwner(value);
        return this;
    }

    public Account withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    @Override
    public Account withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Account withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Account withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Account withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Account withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Account withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Account withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Account withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Account withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Account withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Account withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Account that = (Account)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName, this.name != null, that.name != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        AccountStatus lhsStatus = this.getStatus();
        AccountStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Period lhsActivePeriod = this.getActivePeriod();
        Period rhsActivePeriod = that.getActivePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"activePeriod", (Object)lhsActivePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"activePeriod", (Object)rhsActivePeriod), (Object)lhsActivePeriod, (Object)rhsActivePeriod, this.activePeriod != null, that.activePeriod != null)) {
            return false;
        }
        Coding lhsCurrency = this.getCurrency();
        Coding rhsCurrency = that.getCurrency();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"currency", (Object)lhsCurrency), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"currency", (Object)rhsCurrency), (Object)lhsCurrency, (Object)rhsCurrency, this.currency != null, that.currency != null)) {
            return false;
        }
        Money lhsBalance = this.getBalance();
        Money rhsBalance = that.getBalance();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"balance", (Object)lhsBalance), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"balance", (Object)rhsBalance), (Object)lhsBalance, (Object)rhsBalance, this.balance != null, that.balance != null)) {
            return false;
        }
        Period lhsCoveragePeriod = this.getCoveragePeriod();
        Period rhsCoveragePeriod = that.getCoveragePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"coveragePeriod", (Object)lhsCoveragePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"coveragePeriod", (Object)rhsCoveragePeriod), (Object)lhsCoveragePeriod, (Object)rhsCoveragePeriod, this.coveragePeriod != null, that.coveragePeriod != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Reference lhsOwner = this.getOwner();
        Reference rhsOwner = that.getOwner();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"owner", (Object)lhsOwner), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"owner", (Object)rhsOwner), (Object)lhsOwner, (Object)rhsOwner, this.owner != null, that.owner != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName, this.name != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        AccountStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Period theActivePeriod = this.getActivePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"activePeriod", (Object)theActivePeriod), currentHashCode, (Object)theActivePeriod, this.activePeriod != null);
        Coding theCurrency = this.getCurrency();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"currency", (Object)theCurrency), currentHashCode, (Object)theCurrency, this.currency != null);
        Money theBalance = this.getBalance();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"balance", (Object)theBalance), currentHashCode, (Object)theBalance, this.balance != null);
        Period theCoveragePeriod = this.getCoveragePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"coveragePeriod", (Object)theCoveragePeriod), currentHashCode, (Object)theCoveragePeriod, this.coveragePeriod != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject, this.subject != null);
        Reference theOwner = this.getOwner();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"owner", (Object)theOwner), currentHashCode, (Object)theOwner, this.owner != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName, this.name != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        AccountStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Period theActivePeriod = this.getActivePeriod();
        strategy.appendField(locator, (Object)this, "activePeriod", buffer, (Object)theActivePeriod, this.activePeriod != null);
        Coding theCurrency = this.getCurrency();
        strategy.appendField(locator, (Object)this, "currency", buffer, (Object)theCurrency, this.currency != null);
        Money theBalance = this.getBalance();
        strategy.appendField(locator, (Object)this, "balance", buffer, (Object)theBalance, this.balance != null);
        Period theCoveragePeriod = this.getCoveragePeriod();
        strategy.appendField(locator, (Object)this, "coveragePeriod", buffer, (Object)theCoveragePeriod, this.coveragePeriod != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject, this.subject != null);
        Reference theOwner = this.getOwner();
        strategy.appendField(locator, (Object)this, "owner", buffer, (Object)theOwner, this.owner != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        return buffer;
    }
}

