/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Decimal;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Integer;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SequenceQuality;
import org.hl7.fhir.SequenceReferenceSeq;
import org.hl7.fhir.SequenceRepository;
import org.hl7.fhir.SequenceStructureVariation;
import org.hl7.fhir.SequenceType;
import org.hl7.fhir.SequenceVariation;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Sequence", propOrder={"type", "patient", "specimen", "device", "quantity", "species", "referenceSeq", "variation", "quality", "allelicState", "allelicFrequency", "copyNumberEvent", "readCoverage", "repository", "pointer", "observedSeq", "observation", "structureVariation"})
public class Sequence
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected SequenceType type;
    protected Reference patient;
    protected Reference specimen;
    protected Reference device;
    protected Quantity quantity;
    protected CodeableConcept species;
    protected List<SequenceReferenceSeq> referenceSeq;
    protected SequenceVariation variation;
    protected List<SequenceQuality> quality;
    protected CodeableConcept allelicState;
    protected Decimal allelicFrequency;
    protected CodeableConcept copyNumberEvent;
    protected Integer readCoverage;
    protected List<SequenceRepository> repository;
    protected List<Reference> pointer;
    protected String observedSeq;
    protected Reference observation;
    protected SequenceStructureVariation structureVariation;

    public SequenceType getType() {
        return this.type;
    }

    public void setType(SequenceType value) {
        this.type = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getSpecimen() {
        return this.specimen;
    }

    public void setSpecimen(Reference value) {
        this.specimen = value;
    }

    public Reference getDevice() {
        return this.device;
    }

    public void setDevice(Reference value) {
        this.device = value;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Quantity value) {
        this.quantity = value;
    }

    public CodeableConcept getSpecies() {
        return this.species;
    }

    public void setSpecies(CodeableConcept value) {
        this.species = value;
    }

    public List<SequenceReferenceSeq> getReferenceSeq() {
        if (this.referenceSeq == null) {
            this.referenceSeq = new ArrayList<SequenceReferenceSeq>();
        }
        return this.referenceSeq;
    }

    public SequenceVariation getVariation() {
        return this.variation;
    }

    public void setVariation(SequenceVariation value) {
        this.variation = value;
    }

    public List<SequenceQuality> getQuality() {
        if (this.quality == null) {
            this.quality = new ArrayList<SequenceQuality>();
        }
        return this.quality;
    }

    public CodeableConcept getAllelicState() {
        return this.allelicState;
    }

    public void setAllelicState(CodeableConcept value) {
        this.allelicState = value;
    }

    public Decimal getAllelicFrequency() {
        return this.allelicFrequency;
    }

    public void setAllelicFrequency(Decimal value) {
        this.allelicFrequency = value;
    }

    public CodeableConcept getCopyNumberEvent() {
        return this.copyNumberEvent;
    }

    public void setCopyNumberEvent(CodeableConcept value) {
        this.copyNumberEvent = value;
    }

    public Integer getReadCoverage() {
        return this.readCoverage;
    }

    public void setReadCoverage(Integer value) {
        this.readCoverage = value;
    }

    public List<SequenceRepository> getRepository() {
        if (this.repository == null) {
            this.repository = new ArrayList<SequenceRepository>();
        }
        return this.repository;
    }

    public List<Reference> getPointer() {
        if (this.pointer == null) {
            this.pointer = new ArrayList<Reference>();
        }
        return this.pointer;
    }

    public String getObservedSeq() {
        return this.observedSeq;
    }

    public void setObservedSeq(String value) {
        this.observedSeq = value;
    }

    public Reference getObservation() {
        return this.observation;
    }

    public void setObservation(Reference value) {
        this.observation = value;
    }

    public SequenceStructureVariation getStructureVariation() {
        return this.structureVariation;
    }

    public void setStructureVariation(SequenceStructureVariation value) {
        this.structureVariation = value;
    }

    public Sequence withType(SequenceType value) {
        this.setType(value);
        return this;
    }

    public Sequence withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Sequence withSpecimen(Reference value) {
        this.setSpecimen(value);
        return this;
    }

    public Sequence withDevice(Reference value) {
        this.setDevice(value);
        return this;
    }

    public Sequence withQuantity(Quantity value) {
        this.setQuantity(value);
        return this;
    }

    public Sequence withSpecies(CodeableConcept value) {
        this.setSpecies(value);
        return this;
    }

    public Sequence withReferenceSeq(SequenceReferenceSeq ... values) {
        if (values != null) {
            for (SequenceReferenceSeq value : values) {
                this.getReferenceSeq().add(value);
            }
        }
        return this;
    }

    public Sequence withReferenceSeq(Collection<SequenceReferenceSeq> values) {
        if (values != null) {
            this.getReferenceSeq().addAll(values);
        }
        return this;
    }

    public Sequence withVariation(SequenceVariation value) {
        this.setVariation(value);
        return this;
    }

    public Sequence withQuality(SequenceQuality ... values) {
        if (values != null) {
            for (SequenceQuality value : values) {
                this.getQuality().add(value);
            }
        }
        return this;
    }

    public Sequence withQuality(Collection<SequenceQuality> values) {
        if (values != null) {
            this.getQuality().addAll(values);
        }
        return this;
    }

    public Sequence withAllelicState(CodeableConcept value) {
        this.setAllelicState(value);
        return this;
    }

    public Sequence withAllelicFrequency(Decimal value) {
        this.setAllelicFrequency(value);
        return this;
    }

    public Sequence withCopyNumberEvent(CodeableConcept value) {
        this.setCopyNumberEvent(value);
        return this;
    }

    public Sequence withReadCoverage(Integer value) {
        this.setReadCoverage(value);
        return this;
    }

    public Sequence withRepository(SequenceRepository ... values) {
        if (values != null) {
            for (SequenceRepository value : values) {
                this.getRepository().add(value);
            }
        }
        return this;
    }

    public Sequence withRepository(Collection<SequenceRepository> values) {
        if (values != null) {
            this.getRepository().addAll(values);
        }
        return this;
    }

    public Sequence withPointer(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getPointer().add(value);
            }
        }
        return this;
    }

    public Sequence withPointer(Collection<Reference> values) {
        if (values != null) {
            this.getPointer().addAll(values);
        }
        return this;
    }

    public Sequence withObservedSeq(String value) {
        this.setObservedSeq(value);
        return this;
    }

    public Sequence withObservation(Reference value) {
        this.setObservation(value);
        return this;
    }

    public Sequence withStructureVariation(SequenceStructureVariation value) {
        this.setStructureVariation(value);
        return this;
    }

    @Override
    public Sequence withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Sequence withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Sequence withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Sequence withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Sequence withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Sequence withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Sequence withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Sequence withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Sequence withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Sequence withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Sequence withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Sequence that = (Sequence)object;
        SequenceType lhsType = this.getType();
        SequenceType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsSpecimen = this.getSpecimen();
        Reference rhsSpecimen = that.getSpecimen();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specimen", (Object)lhsSpecimen), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specimen", (Object)rhsSpecimen), (Object)lhsSpecimen, (Object)rhsSpecimen, this.specimen != null, that.specimen != null)) {
            return false;
        }
        Reference lhsDevice = this.getDevice();
        Reference rhsDevice = that.getDevice();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"device", (Object)lhsDevice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"device", (Object)rhsDevice), (Object)lhsDevice, (Object)rhsDevice, this.device != null, that.device != null)) {
            return false;
        }
        Quantity lhsQuantity = this.getQuantity();
        Quantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity, this.quantity != null, that.quantity != null)) {
            return false;
        }
        CodeableConcept lhsSpecies = this.getSpecies();
        CodeableConcept rhsSpecies = that.getSpecies();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"species", (Object)lhsSpecies), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"species", (Object)rhsSpecies), (Object)lhsSpecies, (Object)rhsSpecies, this.species != null, that.species != null)) {
            return false;
        }
        List<SequenceReferenceSeq> lhsReferenceSeq = this.referenceSeq != null && !this.referenceSeq.isEmpty() ? this.getReferenceSeq() : null;
        List<SequenceReferenceSeq> rhsReferenceSeq = that.referenceSeq != null && !that.referenceSeq.isEmpty() ? that.getReferenceSeq() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"referenceSeq", lhsReferenceSeq), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"referenceSeq", rhsReferenceSeq), lhsReferenceSeq, rhsReferenceSeq, this.referenceSeq != null && !this.referenceSeq.isEmpty(), that.referenceSeq != null && !that.referenceSeq.isEmpty())) {
            return false;
        }
        SequenceVariation lhsVariation = this.getVariation();
        SequenceVariation rhsVariation = that.getVariation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"variation", (Object)lhsVariation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"variation", (Object)rhsVariation), (Object)lhsVariation, (Object)rhsVariation, this.variation != null, that.variation != null)) {
            return false;
        }
        List<SequenceQuality> lhsQuality = this.quality != null && !this.quality.isEmpty() ? this.getQuality() : null;
        List<SequenceQuality> rhsQuality = that.quality != null && !that.quality.isEmpty() ? that.getQuality() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"quality", lhsQuality), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"quality", rhsQuality), lhsQuality, rhsQuality, this.quality != null && !this.quality.isEmpty(), that.quality != null && !that.quality.isEmpty())) {
            return false;
        }
        CodeableConcept lhsAllelicState = this.getAllelicState();
        CodeableConcept rhsAllelicState = that.getAllelicState();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"allelicState", (Object)lhsAllelicState), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"allelicState", (Object)rhsAllelicState), (Object)lhsAllelicState, (Object)rhsAllelicState, this.allelicState != null, that.allelicState != null)) {
            return false;
        }
        Decimal lhsAllelicFrequency = this.getAllelicFrequency();
        Decimal rhsAllelicFrequency = that.getAllelicFrequency();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"allelicFrequency", (Object)lhsAllelicFrequency), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"allelicFrequency", (Object)rhsAllelicFrequency), (Object)lhsAllelicFrequency, (Object)rhsAllelicFrequency, this.allelicFrequency != null, that.allelicFrequency != null)) {
            return false;
        }
        CodeableConcept lhsCopyNumberEvent = this.getCopyNumberEvent();
        CodeableConcept rhsCopyNumberEvent = that.getCopyNumberEvent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyNumberEvent", (Object)lhsCopyNumberEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyNumberEvent", (Object)rhsCopyNumberEvent), (Object)lhsCopyNumberEvent, (Object)rhsCopyNumberEvent, this.copyNumberEvent != null, that.copyNumberEvent != null)) {
            return false;
        }
        Integer lhsReadCoverage = this.getReadCoverage();
        Integer rhsReadCoverage = that.getReadCoverage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"readCoverage", (Object)lhsReadCoverage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"readCoverage", (Object)rhsReadCoverage), (Object)lhsReadCoverage, (Object)rhsReadCoverage, this.readCoverage != null, that.readCoverage != null)) {
            return false;
        }
        List<SequenceRepository> lhsRepository = this.repository != null && !this.repository.isEmpty() ? this.getRepository() : null;
        List<SequenceRepository> rhsRepository = that.repository != null && !that.repository.isEmpty() ? that.getRepository() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"repository", lhsRepository), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"repository", rhsRepository), lhsRepository, rhsRepository, this.repository != null && !this.repository.isEmpty(), that.repository != null && !that.repository.isEmpty())) {
            return false;
        }
        List<Reference> lhsPointer = this.pointer != null && !this.pointer.isEmpty() ? this.getPointer() : null;
        List<Reference> rhsPointer = that.pointer != null && !that.pointer.isEmpty() ? that.getPointer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"pointer", lhsPointer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"pointer", rhsPointer), lhsPointer, rhsPointer, this.pointer != null && !this.pointer.isEmpty(), that.pointer != null && !that.pointer.isEmpty())) {
            return false;
        }
        String lhsObservedSeq = this.getObservedSeq();
        String rhsObservedSeq = that.getObservedSeq();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"observedSeq", (Object)lhsObservedSeq), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"observedSeq", (Object)rhsObservedSeq), (Object)lhsObservedSeq, (Object)rhsObservedSeq, this.observedSeq != null, that.observedSeq != null)) {
            return false;
        }
        Reference lhsObservation = this.getObservation();
        Reference rhsObservation = that.getObservation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"observation", (Object)lhsObservation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"observation", (Object)rhsObservation), (Object)lhsObservation, (Object)rhsObservation, this.observation != null, that.observation != null)) {
            return false;
        }
        SequenceStructureVariation lhsStructureVariation = this.getStructureVariation();
        SequenceStructureVariation rhsStructureVariation = that.getStructureVariation();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"structureVariation", (Object)lhsStructureVariation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"structureVariation", (Object)rhsStructureVariation), (Object)lhsStructureVariation, (Object)rhsStructureVariation, this.structureVariation != null, that.structureVariation != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        SequenceType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        Reference theSpecimen = this.getSpecimen();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specimen", (Object)theSpecimen), currentHashCode, (Object)theSpecimen, this.specimen != null);
        Reference theDevice = this.getDevice();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"device", (Object)theDevice), currentHashCode, (Object)theDevice, this.device != null);
        Quantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity, this.quantity != null);
        CodeableConcept theSpecies = this.getSpecies();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"species", (Object)theSpecies), currentHashCode, (Object)theSpecies, this.species != null);
        List<SequenceReferenceSeq> theReferenceSeq = this.referenceSeq != null && !this.referenceSeq.isEmpty() ? this.getReferenceSeq() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"referenceSeq", theReferenceSeq), currentHashCode, theReferenceSeq, this.referenceSeq != null && !this.referenceSeq.isEmpty());
        SequenceVariation theVariation = this.getVariation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"variation", (Object)theVariation), currentHashCode, (Object)theVariation, this.variation != null);
        List<SequenceQuality> theQuality = this.quality != null && !this.quality.isEmpty() ? this.getQuality() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"quality", theQuality), currentHashCode, theQuality, this.quality != null && !this.quality.isEmpty());
        CodeableConcept theAllelicState = this.getAllelicState();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"allelicState", (Object)theAllelicState), currentHashCode, (Object)theAllelicState, this.allelicState != null);
        Decimal theAllelicFrequency = this.getAllelicFrequency();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"allelicFrequency", (Object)theAllelicFrequency), currentHashCode, (Object)theAllelicFrequency, this.allelicFrequency != null);
        CodeableConcept theCopyNumberEvent = this.getCopyNumberEvent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyNumberEvent", (Object)theCopyNumberEvent), currentHashCode, (Object)theCopyNumberEvent, this.copyNumberEvent != null);
        Integer theReadCoverage = this.getReadCoverage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"readCoverage", (Object)theReadCoverage), currentHashCode, (Object)theReadCoverage, this.readCoverage != null);
        List<SequenceRepository> theRepository = this.repository != null && !this.repository.isEmpty() ? this.getRepository() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"repository", theRepository), currentHashCode, theRepository, this.repository != null && !this.repository.isEmpty());
        List<Reference> thePointer = this.pointer != null && !this.pointer.isEmpty() ? this.getPointer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"pointer", thePointer), currentHashCode, thePointer, this.pointer != null && !this.pointer.isEmpty());
        String theObservedSeq = this.getObservedSeq();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"observedSeq", (Object)theObservedSeq), currentHashCode, (Object)theObservedSeq, this.observedSeq != null);
        Reference theObservation = this.getObservation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"observation", (Object)theObservation), currentHashCode, (Object)theObservation, this.observation != null);
        SequenceStructureVariation theStructureVariation = this.getStructureVariation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"structureVariation", (Object)theStructureVariation), currentHashCode, (Object)theStructureVariation, this.structureVariation != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        SequenceType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        Reference theSpecimen = this.getSpecimen();
        strategy.appendField(locator, (Object)this, "specimen", buffer, (Object)theSpecimen, this.specimen != null);
        Reference theDevice = this.getDevice();
        strategy.appendField(locator, (Object)this, "device", buffer, (Object)theDevice, this.device != null);
        Quantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity, this.quantity != null);
        CodeableConcept theSpecies = this.getSpecies();
        strategy.appendField(locator, (Object)this, "species", buffer, (Object)theSpecies, this.species != null);
        List<SequenceReferenceSeq> theReferenceSeq = this.referenceSeq != null && !this.referenceSeq.isEmpty() ? this.getReferenceSeq() : null;
        strategy.appendField(locator, (Object)this, "referenceSeq", buffer, theReferenceSeq, this.referenceSeq != null && !this.referenceSeq.isEmpty());
        SequenceVariation theVariation = this.getVariation();
        strategy.appendField(locator, (Object)this, "variation", buffer, (Object)theVariation, this.variation != null);
        List<SequenceQuality> theQuality = this.quality != null && !this.quality.isEmpty() ? this.getQuality() : null;
        strategy.appendField(locator, (Object)this, "quality", buffer, theQuality, this.quality != null && !this.quality.isEmpty());
        CodeableConcept theAllelicState = this.getAllelicState();
        strategy.appendField(locator, (Object)this, "allelicState", buffer, (Object)theAllelicState, this.allelicState != null);
        Decimal theAllelicFrequency = this.getAllelicFrequency();
        strategy.appendField(locator, (Object)this, "allelicFrequency", buffer, (Object)theAllelicFrequency, this.allelicFrequency != null);
        CodeableConcept theCopyNumberEvent = this.getCopyNumberEvent();
        strategy.appendField(locator, (Object)this, "copyNumberEvent", buffer, (Object)theCopyNumberEvent, this.copyNumberEvent != null);
        Integer theReadCoverage = this.getReadCoverage();
        strategy.appendField(locator, (Object)this, "readCoverage", buffer, (Object)theReadCoverage, this.readCoverage != null);
        List<SequenceRepository> theRepository = this.repository != null && !this.repository.isEmpty() ? this.getRepository() : null;
        strategy.appendField(locator, (Object)this, "repository", buffer, theRepository, this.repository != null && !this.repository.isEmpty());
        List<Reference> thePointer = this.pointer != null && !this.pointer.isEmpty() ? this.getPointer() : null;
        strategy.appendField(locator, (Object)this, "pointer", buffer, thePointer, this.pointer != null && !this.pointer.isEmpty());
        String theObservedSeq = this.getObservedSeq();
        strategy.appendField(locator, (Object)this, "observedSeq", buffer, (Object)theObservedSeq, this.observedSeq != null);
        Reference theObservation = this.getObservation();
        strategy.appendField(locator, (Object)this, "observation", buffer, (Object)theObservation, this.observation != null);
        SequenceStructureVariation theStructureVariation = this.getStructureVariation();
        strategy.appendField(locator, (Object)this, "structureVariation", buffer, (Object)theStructureVariation, this.structureVariation != null);
        return buffer;
    }

    public void setReferenceSeq(List<SequenceReferenceSeq> value) {
        this.referenceSeq = value;
    }

    public void setQuality(List<SequenceQuality> value) {
        this.quality = value;
    }

    public void setRepository(List<SequenceRepository> value) {
        this.repository = value;
    }

    public void setPointer(List<Reference> value) {
        this.pointer = value;
    }
}

