/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Code;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.QuestionnaireResponseItem;
import org.hl7.fhir.QuestionnaireResponseStatus;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QuestionnaireResponse", propOrder={"identifier", "questionnaire", "status", "subject", "author", "authored", "source", "encounter", "item"})
public class QuestionnaireResponse
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier identifier;
    protected Reference questionnaire;
    @XmlElement(required=true)
    protected QuestionnaireResponseStatus status;
    protected Reference subject;
    protected Reference author;
    protected DateTime authored;
    protected Reference source;
    protected Reference encounter;
    protected List<QuestionnaireResponseItem> item;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public Reference getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Reference value) {
        this.questionnaire = value;
    }

    public QuestionnaireResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(QuestionnaireResponseStatus value) {
        this.status = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public void setAuthor(Reference value) {
        this.author = value;
    }

    public DateTime getAuthored() {
        return this.authored;
    }

    public void setAuthored(DateTime value) {
        this.authored = value;
    }

    public Reference getSource() {
        return this.source;
    }

    public void setSource(Reference value) {
        this.source = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public List<QuestionnaireResponseItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItem>();
        }
        return this.item;
    }

    public QuestionnaireResponse withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public QuestionnaireResponse withQuestionnaire(Reference value) {
        this.setQuestionnaire(value);
        return this;
    }

    public QuestionnaireResponse withStatus(QuestionnaireResponseStatus value) {
        this.setStatus(value);
        return this;
    }

    public QuestionnaireResponse withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public QuestionnaireResponse withAuthor(Reference value) {
        this.setAuthor(value);
        return this;
    }

    public QuestionnaireResponse withAuthored(DateTime value) {
        this.setAuthored(value);
        return this;
    }

    public QuestionnaireResponse withSource(Reference value) {
        this.setSource(value);
        return this;
    }

    public QuestionnaireResponse withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public QuestionnaireResponse withItem(QuestionnaireResponseItem ... values) {
        if (values != null) {
            for (QuestionnaireResponseItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public QuestionnaireResponse withItem(Collection<QuestionnaireResponseItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireResponse withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public QuestionnaireResponse withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireResponse withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireResponse withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireResponse withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireResponse withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireResponse withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireResponse withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public QuestionnaireResponse withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public QuestionnaireResponse withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public QuestionnaireResponse withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        QuestionnaireResponse that = (QuestionnaireResponse)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        Reference lhsQuestionnaire = this.getQuestionnaire();
        Reference rhsQuestionnaire = that.getQuestionnaire();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"questionnaire", (Object)lhsQuestionnaire), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"questionnaire", (Object)rhsQuestionnaire), (Object)lhsQuestionnaire, (Object)rhsQuestionnaire, this.questionnaire != null, that.questionnaire != null)) {
            return false;
        }
        QuestionnaireResponseStatus lhsStatus = this.getStatus();
        QuestionnaireResponseStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Reference lhsAuthor = this.getAuthor();
        Reference rhsAuthor = that.getAuthor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"author", (Object)lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"author", (Object)rhsAuthor), (Object)lhsAuthor, (Object)rhsAuthor, this.author != null, that.author != null)) {
            return false;
        }
        DateTime lhsAuthored = this.getAuthored();
        DateTime rhsAuthored = that.getAuthored();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"authored", (Object)lhsAuthored), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"authored", (Object)rhsAuthored), (Object)lhsAuthored, (Object)rhsAuthored, this.authored != null, that.authored != null)) {
            return false;
        }
        Reference lhsSource = this.getSource();
        Reference rhsSource = that.getSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"source", (Object)lhsSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"source", (Object)rhsSource), (Object)lhsSource, (Object)rhsSource, this.source != null, that.source != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        List<QuestionnaireResponseItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<QuestionnaireResponseItem> rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"item", lhsItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"item", rhsItem), lhsItem, rhsItem, this.item != null && !this.item.isEmpty(), that.item != null && !that.item.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier, this.identifier != null);
        Reference theQuestionnaire = this.getQuestionnaire();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"questionnaire", (Object)theQuestionnaire), currentHashCode, (Object)theQuestionnaire, this.questionnaire != null);
        QuestionnaireResponseStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject, this.subject != null);
        Reference theAuthor = this.getAuthor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"author", (Object)theAuthor), currentHashCode, (Object)theAuthor, this.author != null);
        DateTime theAuthored = this.getAuthored();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"authored", (Object)theAuthored), currentHashCode, (Object)theAuthored, this.authored != null);
        Reference theSource = this.getSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"source", (Object)theSource), currentHashCode, (Object)theSource, this.source != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter, this.encounter != null);
        List<QuestionnaireResponseItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"item", theItem), currentHashCode, theItem, this.item != null && !this.item.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier, this.identifier != null);
        Reference theQuestionnaire = this.getQuestionnaire();
        strategy.appendField(locator, (Object)this, "questionnaire", buffer, (Object)theQuestionnaire, this.questionnaire != null);
        QuestionnaireResponseStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject, this.subject != null);
        Reference theAuthor = this.getAuthor();
        strategy.appendField(locator, (Object)this, "author", buffer, (Object)theAuthor, this.author != null);
        DateTime theAuthored = this.getAuthored();
        strategy.appendField(locator, (Object)this, "authored", buffer, (Object)theAuthored, this.authored != null);
        Reference theSource = this.getSource();
        strategy.appendField(locator, (Object)this, "source", buffer, (Object)theSource, this.source != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter, this.encounter != null);
        List<QuestionnaireResponseItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem, this.item != null && !this.item.isEmpty());
        return buffer;
    }

    public void setItem(List<QuestionnaireResponseItem> value) {
        this.item = value;
    }
}

