/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Timing;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DeviceUseStatement", propOrder={"bodySiteCodeableConcept", "bodySiteReference", "whenUsed", "device", "identifier", "indication", "notes", "recordedOn", "subject", "timingTiming", "timingPeriod", "timingDateTime"})
public class DeviceUseStatement
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept bodySiteCodeableConcept;
    protected Reference bodySiteReference;
    protected Period whenUsed;
    @XmlElement(required=true)
    protected Reference device;
    protected List<Identifier> identifier;
    protected List<CodeableConcept> indication;
    protected List<String> notes;
    protected DateTime recordedOn;
    @XmlElement(required=true)
    protected Reference subject;
    protected Timing timingTiming;
    protected Period timingPeriod;
    protected DateTime timingDateTime;

    public CodeableConcept getBodySiteCodeableConcept() {
        return this.bodySiteCodeableConcept;
    }

    public void setBodySiteCodeableConcept(CodeableConcept value) {
        this.bodySiteCodeableConcept = value;
    }

    public Reference getBodySiteReference() {
        return this.bodySiteReference;
    }

    public void setBodySiteReference(Reference value) {
        this.bodySiteReference = value;
    }

    public Period getWhenUsed() {
        return this.whenUsed;
    }

    public void setWhenUsed(Period value) {
        this.whenUsed = value;
    }

    public Reference getDevice() {
        return this.device;
    }

    public void setDevice(Reference value) {
        this.device = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public List<CodeableConcept> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        return this.indication;
    }

    public List<String> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        return this.notes;
    }

    public DateTime getRecordedOn() {
        return this.recordedOn;
    }

    public void setRecordedOn(DateTime value) {
        this.recordedOn = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Timing getTimingTiming() {
        return this.timingTiming;
    }

    public void setTimingTiming(Timing value) {
        this.timingTiming = value;
    }

    public Period getTimingPeriod() {
        return this.timingPeriod;
    }

    public void setTimingPeriod(Period value) {
        this.timingPeriod = value;
    }

    public DateTime getTimingDateTime() {
        return this.timingDateTime;
    }

    public void setTimingDateTime(DateTime value) {
        this.timingDateTime = value;
    }

    public DeviceUseStatement withBodySiteCodeableConcept(CodeableConcept value) {
        this.setBodySiteCodeableConcept(value);
        return this;
    }

    public DeviceUseStatement withBodySiteReference(Reference value) {
        this.setBodySiteReference(value);
        return this;
    }

    public DeviceUseStatement withWhenUsed(Period value) {
        this.setWhenUsed(value);
        return this;
    }

    public DeviceUseStatement withDevice(Reference value) {
        this.setDevice(value);
        return this;
    }

    public DeviceUseStatement withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public DeviceUseStatement withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public DeviceUseStatement withIndication(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getIndication().add(value);
            }
        }
        return this;
    }

    public DeviceUseStatement withIndication(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getIndication().addAll(values);
        }
        return this;
    }

    public DeviceUseStatement withNotes(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getNotes().add(value);
            }
        }
        return this;
    }

    public DeviceUseStatement withNotes(Collection<String> values) {
        if (values != null) {
            this.getNotes().addAll(values);
        }
        return this;
    }

    public DeviceUseStatement withRecordedOn(DateTime value) {
        this.setRecordedOn(value);
        return this;
    }

    public DeviceUseStatement withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public DeviceUseStatement withTimingTiming(Timing value) {
        this.setTimingTiming(value);
        return this;
    }

    public DeviceUseStatement withTimingPeriod(Period value) {
        this.setTimingPeriod(value);
        return this;
    }

    public DeviceUseStatement withTimingDateTime(DateTime value) {
        this.setTimingDateTime(value);
        return this;
    }

    @Override
    public DeviceUseStatement withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DeviceUseStatement withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DeviceUseStatement withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DeviceUseStatement withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DeviceUseStatement withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DeviceUseStatement withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DeviceUseStatement withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DeviceUseStatement withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DeviceUseStatement withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DeviceUseStatement withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DeviceUseStatement withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DeviceUseStatement that = (DeviceUseStatement)object;
        CodeableConcept lhsBodySiteCodeableConcept = this.getBodySiteCodeableConcept();
        CodeableConcept rhsBodySiteCodeableConcept = that.getBodySiteCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bodySiteCodeableConcept", (Object)lhsBodySiteCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bodySiteCodeableConcept", (Object)rhsBodySiteCodeableConcept), (Object)lhsBodySiteCodeableConcept, (Object)rhsBodySiteCodeableConcept, this.bodySiteCodeableConcept != null, that.bodySiteCodeableConcept != null)) {
            return false;
        }
        Reference lhsBodySiteReference = this.getBodySiteReference();
        Reference rhsBodySiteReference = that.getBodySiteReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bodySiteReference", (Object)lhsBodySiteReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bodySiteReference", (Object)rhsBodySiteReference), (Object)lhsBodySiteReference, (Object)rhsBodySiteReference, this.bodySiteReference != null, that.bodySiteReference != null)) {
            return false;
        }
        Period lhsWhenUsed = this.getWhenUsed();
        Period rhsWhenUsed = that.getWhenUsed();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"whenUsed", (Object)lhsWhenUsed), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"whenUsed", (Object)rhsWhenUsed), (Object)lhsWhenUsed, (Object)rhsWhenUsed, this.whenUsed != null, that.whenUsed != null)) {
            return false;
        }
        Reference lhsDevice = this.getDevice();
        Reference rhsDevice = that.getDevice();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"device", (Object)lhsDevice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"device", (Object)rhsDevice), (Object)lhsDevice, (Object)rhsDevice, this.device != null, that.device != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        List<CodeableConcept> rhsIndication = that.indication != null && !that.indication.isEmpty() ? that.getIndication() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"indication", lhsIndication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"indication", rhsIndication), lhsIndication, rhsIndication, this.indication != null && !this.indication.isEmpty(), that.indication != null && !that.indication.isEmpty())) {
            return false;
        }
        List<String> lhsNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        List<String> rhsNotes = that.notes != null && !that.notes.isEmpty() ? that.getNotes() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notes", lhsNotes), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notes", rhsNotes), lhsNotes, rhsNotes, this.notes != null && !this.notes.isEmpty(), that.notes != null && !that.notes.isEmpty())) {
            return false;
        }
        DateTime lhsRecordedOn = this.getRecordedOn();
        DateTime rhsRecordedOn = that.getRecordedOn();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"recordedOn", (Object)lhsRecordedOn), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"recordedOn", (Object)rhsRecordedOn), (Object)lhsRecordedOn, (Object)rhsRecordedOn, this.recordedOn != null, that.recordedOn != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Timing lhsTimingTiming = this.getTimingTiming();
        Timing rhsTimingTiming = that.getTimingTiming();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"timingTiming", (Object)lhsTimingTiming), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"timingTiming", (Object)rhsTimingTiming), (Object)lhsTimingTiming, (Object)rhsTimingTiming, this.timingTiming != null, that.timingTiming != null)) {
            return false;
        }
        Period lhsTimingPeriod = this.getTimingPeriod();
        Period rhsTimingPeriod = that.getTimingPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"timingPeriod", (Object)lhsTimingPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"timingPeriod", (Object)rhsTimingPeriod), (Object)lhsTimingPeriod, (Object)rhsTimingPeriod, this.timingPeriod != null, that.timingPeriod != null)) {
            return false;
        }
        DateTime lhsTimingDateTime = this.getTimingDateTime();
        DateTime rhsTimingDateTime = that.getTimingDateTime();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"timingDateTime", (Object)lhsTimingDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"timingDateTime", (Object)rhsTimingDateTime), (Object)lhsTimingDateTime, (Object)rhsTimingDateTime, this.timingDateTime != null, that.timingDateTime != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theBodySiteCodeableConcept = this.getBodySiteCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bodySiteCodeableConcept", (Object)theBodySiteCodeableConcept), currentHashCode, (Object)theBodySiteCodeableConcept, this.bodySiteCodeableConcept != null);
        Reference theBodySiteReference = this.getBodySiteReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bodySiteReference", (Object)theBodySiteReference), currentHashCode, (Object)theBodySiteReference, this.bodySiteReference != null);
        Period theWhenUsed = this.getWhenUsed();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"whenUsed", (Object)theWhenUsed), currentHashCode, (Object)theWhenUsed, this.whenUsed != null);
        Reference theDevice = this.getDevice();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"device", (Object)theDevice), currentHashCode, (Object)theDevice, this.device != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        List<CodeableConcept> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"indication", theIndication), currentHashCode, theIndication, this.indication != null && !this.indication.isEmpty());
        List<String> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notes", theNotes), currentHashCode, theNotes, this.notes != null && !this.notes.isEmpty());
        DateTime theRecordedOn = this.getRecordedOn();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"recordedOn", (Object)theRecordedOn), currentHashCode, (Object)theRecordedOn, this.recordedOn != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject, this.subject != null);
        Timing theTimingTiming = this.getTimingTiming();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"timingTiming", (Object)theTimingTiming), currentHashCode, (Object)theTimingTiming, this.timingTiming != null);
        Period theTimingPeriod = this.getTimingPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"timingPeriod", (Object)theTimingPeriod), currentHashCode, (Object)theTimingPeriod, this.timingPeriod != null);
        DateTime theTimingDateTime = this.getTimingDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"timingDateTime", (Object)theTimingDateTime), currentHashCode, (Object)theTimingDateTime, this.timingDateTime != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theBodySiteCodeableConcept = this.getBodySiteCodeableConcept();
        strategy.appendField(locator, (Object)this, "bodySiteCodeableConcept", buffer, (Object)theBodySiteCodeableConcept, this.bodySiteCodeableConcept != null);
        Reference theBodySiteReference = this.getBodySiteReference();
        strategy.appendField(locator, (Object)this, "bodySiteReference", buffer, (Object)theBodySiteReference, this.bodySiteReference != null);
        Period theWhenUsed = this.getWhenUsed();
        strategy.appendField(locator, (Object)this, "whenUsed", buffer, (Object)theWhenUsed, this.whenUsed != null);
        Reference theDevice = this.getDevice();
        strategy.appendField(locator, (Object)this, "device", buffer, (Object)theDevice, this.device != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        List<CodeableConcept> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        strategy.appendField(locator, (Object)this, "indication", buffer, theIndication, this.indication != null && !this.indication.isEmpty());
        List<String> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        strategy.appendField(locator, (Object)this, "notes", buffer, theNotes, this.notes != null && !this.notes.isEmpty());
        DateTime theRecordedOn = this.getRecordedOn();
        strategy.appendField(locator, (Object)this, "recordedOn", buffer, (Object)theRecordedOn, this.recordedOn != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject, this.subject != null);
        Timing theTimingTiming = this.getTimingTiming();
        strategy.appendField(locator, (Object)this, "timingTiming", buffer, (Object)theTimingTiming, this.timingTiming != null);
        Period theTimingPeriod = this.getTimingPeriod();
        strategy.appendField(locator, (Object)this, "timingPeriod", buffer, (Object)theTimingPeriod, this.timingPeriod != null);
        DateTime theTimingDateTime = this.getTimingDateTime();
        strategy.appendField(locator, (Object)this, "timingDateTime", buffer, (Object)theTimingDateTime, this.timingDateTime != null);
        return buffer;
    }
}

