/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.IssueSeverity;
import org.hl7.fhir.IssueType;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OperationOutcome.Issue", propOrder={"severity", "code", "details", "diagnostics", "location", "expression"})
public class OperationOutcomeIssue
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected IssueSeverity severity;
    @XmlElement(required=true)
    protected IssueType code;
    protected CodeableConcept details;
    protected String diagnostics;
    protected List<String> location;
    protected List<String> expression;

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(IssueSeverity value) {
        this.severity = value;
    }

    public IssueType getCode() {
        return this.code;
    }

    public void setCode(IssueType value) {
        this.code = value;
    }

    public CodeableConcept getDetails() {
        return this.details;
    }

    public void setDetails(CodeableConcept value) {
        this.details = value;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(String value) {
        this.diagnostics = value;
    }

    public List<String> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<String>();
        }
        return this.location;
    }

    public List<String> getExpression() {
        if (this.expression == null) {
            this.expression = new ArrayList<String>();
        }
        return this.expression;
    }

    public OperationOutcomeIssue withSeverity(IssueSeverity value) {
        this.setSeverity(value);
        return this;
    }

    public OperationOutcomeIssue withCode(IssueType value) {
        this.setCode(value);
        return this;
    }

    public OperationOutcomeIssue withDetails(CodeableConcept value) {
        this.setDetails(value);
        return this;
    }

    public OperationOutcomeIssue withDiagnostics(String value) {
        this.setDiagnostics(value);
        return this;
    }

    public OperationOutcomeIssue withLocation(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getLocation().add(value);
            }
        }
        return this;
    }

    public OperationOutcomeIssue withLocation(Collection<String> values) {
        if (values != null) {
            this.getLocation().addAll(values);
        }
        return this;
    }

    public OperationOutcomeIssue withExpression(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getExpression().add(value);
            }
        }
        return this;
    }

    public OperationOutcomeIssue withExpression(Collection<String> values) {
        if (values != null) {
            this.getExpression().addAll(values);
        }
        return this;
    }

    @Override
    public OperationOutcomeIssue withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OperationOutcomeIssue withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OperationOutcomeIssue withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OperationOutcomeIssue withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OperationOutcomeIssue withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        OperationOutcomeIssue that = (OperationOutcomeIssue)object;
        IssueSeverity lhsSeverity = this.getSeverity();
        IssueSeverity rhsSeverity = that.getSeverity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"severity", (Object)lhsSeverity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"severity", (Object)rhsSeverity), (Object)lhsSeverity, (Object)rhsSeverity, this.severity != null, that.severity != null)) {
            return false;
        }
        IssueType lhsCode = this.getCode();
        IssueType rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        CodeableConcept lhsDetails = this.getDetails();
        CodeableConcept rhsDetails = that.getDetails();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"details", (Object)lhsDetails), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"details", (Object)rhsDetails), (Object)lhsDetails, (Object)rhsDetails, this.details != null, that.details != null)) {
            return false;
        }
        String lhsDiagnostics = this.getDiagnostics();
        String rhsDiagnostics = that.getDiagnostics();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"diagnostics", (Object)lhsDiagnostics), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"diagnostics", (Object)rhsDiagnostics), (Object)lhsDiagnostics, (Object)rhsDiagnostics, this.diagnostics != null, that.diagnostics != null)) {
            return false;
        }
        List<String> lhsLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        List<String> rhsLocation = that.location != null && !that.location.isEmpty() ? that.getLocation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"location", lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"location", rhsLocation), lhsLocation, rhsLocation, this.location != null && !this.location.isEmpty(), that.location != null && !that.location.isEmpty())) {
            return false;
        }
        List<String> lhsExpression = this.expression != null && !this.expression.isEmpty() ? this.getExpression() : null;
        List<String> rhsExpression = that.expression != null && !that.expression.isEmpty() ? that.getExpression() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"expression", lhsExpression), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"expression", rhsExpression), lhsExpression, rhsExpression, this.expression != null && !this.expression.isEmpty(), that.expression != null && !that.expression.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        IssueSeverity theSeverity = this.getSeverity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"severity", (Object)theSeverity), currentHashCode, (Object)theSeverity, this.severity != null);
        IssueType theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode, this.code != null);
        CodeableConcept theDetails = this.getDetails();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"details", (Object)theDetails), currentHashCode, (Object)theDetails, this.details != null);
        String theDiagnostics = this.getDiagnostics();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"diagnostics", (Object)theDiagnostics), currentHashCode, (Object)theDiagnostics, this.diagnostics != null);
        List<String> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"location", theLocation), currentHashCode, theLocation, this.location != null && !this.location.isEmpty());
        List<String> theExpression = this.expression != null && !this.expression.isEmpty() ? this.getExpression() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"expression", theExpression), currentHashCode, theExpression, this.expression != null && !this.expression.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        IssueSeverity theSeverity = this.getSeverity();
        strategy.appendField(locator, (Object)this, "severity", buffer, (Object)theSeverity, this.severity != null);
        IssueType theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode, this.code != null);
        CodeableConcept theDetails = this.getDetails();
        strategy.appendField(locator, (Object)this, "details", buffer, (Object)theDetails, this.details != null);
        String theDiagnostics = this.getDiagnostics();
        strategy.appendField(locator, (Object)this, "diagnostics", buffer, (Object)theDiagnostics, this.diagnostics != null);
        List<String> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation, this.location != null && !this.location.isEmpty());
        List<String> theExpression = this.expression != null && !this.expression.isEmpty() ? this.getExpression() : null;
        strategy.appendField(locator, (Object)this, "expression", buffer, theExpression, this.expression != null && !this.expression.isEmpty());
        return buffer;
    }
}

