/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Integer;
import org.hl7.fhir.Uri;
import org.hl7.fhir.ValueSetContains;
import org.hl7.fhir.ValueSetParameter;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ValueSet.Expansion", propOrder={"identifier", "timestamp", "total", "offset", "parameter", "contains"})
public class ValueSetExpansion
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri identifier;
    @XmlElement(required=true)
    protected DateTime timestamp;
    protected Integer total;
    protected Integer offset;
    protected List<ValueSetParameter> parameter;
    protected List<ValueSetContains> contains;

    public Uri getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Uri value) {
        this.identifier = value;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(DateTime value) {
        this.timestamp = value;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer value) {
        this.total = value;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer value) {
        this.offset = value;
    }

    public List<ValueSetParameter> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ValueSetParameter>();
        }
        return this.parameter;
    }

    public List<ValueSetContains> getContains() {
        if (this.contains == null) {
            this.contains = new ArrayList<ValueSetContains>();
        }
        return this.contains;
    }

    public ValueSetExpansion withIdentifier(Uri value) {
        this.setIdentifier(value);
        return this;
    }

    public ValueSetExpansion withTimestamp(DateTime value) {
        this.setTimestamp(value);
        return this;
    }

    public ValueSetExpansion withTotal(Integer value) {
        this.setTotal(value);
        return this;
    }

    public ValueSetExpansion withOffset(Integer value) {
        this.setOffset(value);
        return this;
    }

    public ValueSetExpansion withParameter(ValueSetParameter ... values) {
        if (values != null) {
            for (ValueSetParameter value : values) {
                this.getParameter().add(value);
            }
        }
        return this;
    }

    public ValueSetExpansion withParameter(Collection<ValueSetParameter> values) {
        if (values != null) {
            this.getParameter().addAll(values);
        }
        return this;
    }

    public ValueSetExpansion withContains(ValueSetContains ... values) {
        if (values != null) {
            for (ValueSetContains value : values) {
                this.getContains().add(value);
            }
        }
        return this;
    }

    public ValueSetExpansion withContains(Collection<ValueSetContains> values) {
        if (values != null) {
            this.getContains().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetExpansion withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetExpansion withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetExpansion withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetExpansion withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetExpansion withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ValueSetExpansion that = (ValueSetExpansion)object;
        Uri lhsIdentifier = this.getIdentifier();
        Uri rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        DateTime lhsTimestamp = this.getTimestamp();
        DateTime rhsTimestamp = that.getTimestamp();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"timestamp", (Object)lhsTimestamp), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"timestamp", (Object)rhsTimestamp), (Object)lhsTimestamp, (Object)rhsTimestamp, this.timestamp != null, that.timestamp != null)) {
            return false;
        }
        Integer lhsTotal = this.getTotal();
        Integer rhsTotal = that.getTotal();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"total", (Object)lhsTotal), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"total", (Object)rhsTotal), (Object)lhsTotal, (Object)rhsTotal, this.total != null, that.total != null)) {
            return false;
        }
        Integer lhsOffset = this.getOffset();
        Integer rhsOffset = that.getOffset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"offset", (Object)lhsOffset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"offset", (Object)rhsOffset), (Object)lhsOffset, (Object)rhsOffset, this.offset != null, that.offset != null)) {
            return false;
        }
        List<ValueSetParameter> lhsParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        List<ValueSetParameter> rhsParameter = that.parameter != null && !that.parameter.isEmpty() ? that.getParameter() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"parameter", lhsParameter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"parameter", rhsParameter), lhsParameter, rhsParameter, this.parameter != null && !this.parameter.isEmpty(), that.parameter != null && !that.parameter.isEmpty())) {
            return false;
        }
        List<ValueSetContains> lhsContains = this.contains != null && !this.contains.isEmpty() ? this.getContains() : null;
        List<ValueSetContains> rhsContains = that.contains != null && !that.contains.isEmpty() ? that.getContains() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"contains", lhsContains), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"contains", rhsContains), lhsContains, rhsContains, this.contains != null && !this.contains.isEmpty(), that.contains != null && !that.contains.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier, this.identifier != null);
        DateTime theTimestamp = this.getTimestamp();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"timestamp", (Object)theTimestamp), currentHashCode, (Object)theTimestamp, this.timestamp != null);
        Integer theTotal = this.getTotal();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"total", (Object)theTotal), currentHashCode, (Object)theTotal, this.total != null);
        Integer theOffset = this.getOffset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"offset", (Object)theOffset), currentHashCode, (Object)theOffset, this.offset != null);
        List<ValueSetParameter> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"parameter", theParameter), currentHashCode, theParameter, this.parameter != null && !this.parameter.isEmpty());
        List<ValueSetContains> theContains = this.contains != null && !this.contains.isEmpty() ? this.getContains() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"contains", theContains), currentHashCode, theContains, this.contains != null && !this.contains.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier, this.identifier != null);
        DateTime theTimestamp = this.getTimestamp();
        strategy.appendField(locator, (Object)this, "timestamp", buffer, (Object)theTimestamp, this.timestamp != null);
        Integer theTotal = this.getTotal();
        strategy.appendField(locator, (Object)this, "total", buffer, (Object)theTotal, this.total != null);
        Integer theOffset = this.getOffset();
        strategy.appendField(locator, (Object)this, "offset", buffer, (Object)theOffset, this.offset != null);
        List<ValueSetParameter> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        strategy.appendField(locator, (Object)this, "parameter", buffer, theParameter, this.parameter != null && !this.parameter.isEmpty());
        List<ValueSetContains> theContains = this.contains != null && !this.contains.isEmpty() ? this.getContains() : null;
        strategy.appendField(locator, (Object)this, "contains", buffer, theContains, this.contains != null && !this.contains.isEmpty());
        return buffer;
    }
}

