/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Schedule", propOrder={"identifier", "serviceCategory", "serviceType", "specialty", "actor", "planningHorizon", "comment"})
public class Schedule
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected CodeableConcept serviceCategory;
    protected List<CodeableConcept> serviceType;
    protected List<CodeableConcept> specialty;
    @XmlElement(required=true)
    protected Reference actor;
    protected Period planningHorizon;
    protected String comment;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CodeableConcept getServiceCategory() {
        return this.serviceCategory;
    }

    public void setServiceCategory(CodeableConcept value) {
        this.serviceCategory = value;
    }

    public List<CodeableConcept> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        return this.serviceType;
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public Reference getActor() {
        return this.actor;
    }

    public void setActor(Reference value) {
        this.actor = value;
    }

    public Period getPlanningHorizon() {
        return this.planningHorizon;
    }

    public void setPlanningHorizon(Period value) {
        this.planningHorizon = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public Schedule withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Schedule withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Schedule withServiceCategory(CodeableConcept value) {
        this.setServiceCategory(value);
        return this;
    }

    public Schedule withServiceType(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getServiceType().add(value);
            }
        }
        return this;
    }

    public Schedule withServiceType(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getServiceType().addAll(values);
        }
        return this;
    }

    public Schedule withSpecialty(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialty().add(value);
            }
        }
        return this;
    }

    public Schedule withSpecialty(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialty().addAll(values);
        }
        return this;
    }

    public Schedule withActor(Reference value) {
        this.setActor(value);
        return this;
    }

    public Schedule withPlanningHorizon(Period value) {
        this.setPlanningHorizon(value);
        return this;
    }

    public Schedule withComment(String value) {
        this.setComment(value);
        return this;
    }

    @Override
    public Schedule withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Schedule withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Schedule withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Schedule withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Schedule withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Schedule withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Schedule withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Schedule withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Schedule withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Schedule withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Schedule withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Schedule that = (Schedule)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        CodeableConcept lhsServiceCategory = this.getServiceCategory();
        CodeableConcept rhsServiceCategory = that.getServiceCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"serviceCategory", (Object)lhsServiceCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"serviceCategory", (Object)rhsServiceCategory), (Object)lhsServiceCategory, (Object)rhsServiceCategory, this.serviceCategory != null, that.serviceCategory != null)) {
            return false;
        }
        List<CodeableConcept> lhsServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        List<CodeableConcept> rhsServiceType = that.serviceType != null && !that.serviceType.isEmpty() ? that.getServiceType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"serviceType", lhsServiceType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"serviceType", rhsServiceType), lhsServiceType, rhsServiceType, this.serviceType != null && !this.serviceType.isEmpty(), that.serviceType != null && !that.serviceType.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        List<CodeableConcept> rhsSpecialty = that.specialty != null && !that.specialty.isEmpty() ? that.getSpecialty() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specialty", lhsSpecialty), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specialty", rhsSpecialty), lhsSpecialty, rhsSpecialty, this.specialty != null && !this.specialty.isEmpty(), that.specialty != null && !that.specialty.isEmpty())) {
            return false;
        }
        Reference lhsActor = this.getActor();
        Reference rhsActor = that.getActor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"actor", (Object)lhsActor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"actor", (Object)rhsActor), (Object)lhsActor, (Object)rhsActor, this.actor != null, that.actor != null)) {
            return false;
        }
        Period lhsPlanningHorizon = this.getPlanningHorizon();
        Period rhsPlanningHorizon = that.getPlanningHorizon();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"planningHorizon", (Object)lhsPlanningHorizon), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"planningHorizon", (Object)rhsPlanningHorizon), (Object)lhsPlanningHorizon, (Object)rhsPlanningHorizon, this.planningHorizon != null, that.planningHorizon != null)) {
            return false;
        }
        String lhsComment = this.getComment();
        String rhsComment = that.getComment();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"comment", (Object)lhsComment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"comment", (Object)rhsComment), (Object)lhsComment, (Object)rhsComment, this.comment != null, that.comment != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        CodeableConcept theServiceCategory = this.getServiceCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"serviceCategory", (Object)theServiceCategory), currentHashCode, (Object)theServiceCategory, this.serviceCategory != null);
        List<CodeableConcept> theServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"serviceType", theServiceType), currentHashCode, theServiceType, this.serviceType != null && !this.serviceType.isEmpty());
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specialty", theSpecialty), currentHashCode, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        Reference theActor = this.getActor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"actor", (Object)theActor), currentHashCode, (Object)theActor, this.actor != null);
        Period thePlanningHorizon = this.getPlanningHorizon();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"planningHorizon", (Object)thePlanningHorizon), currentHashCode, (Object)thePlanningHorizon, this.planningHorizon != null);
        String theComment = this.getComment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"comment", (Object)theComment), currentHashCode, (Object)theComment, this.comment != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        CodeableConcept theServiceCategory = this.getServiceCategory();
        strategy.appendField(locator, (Object)this, "serviceCategory", buffer, (Object)theServiceCategory, this.serviceCategory != null);
        List<CodeableConcept> theServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        strategy.appendField(locator, (Object)this, "serviceType", buffer, theServiceType, this.serviceType != null && !this.serviceType.isEmpty());
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        strategy.appendField(locator, (Object)this, "specialty", buffer, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        Reference theActor = this.getActor();
        strategy.appendField(locator, (Object)this, "actor", buffer, (Object)theActor, this.actor != null);
        Period thePlanningHorizon = this.getPlanningHorizon();
        strategy.appendField(locator, (Object)this, "planningHorizon", buffer, (Object)thePlanningHorizon, this.planningHorizon != null);
        String theComment = this.getComment();
        strategy.appendField(locator, (Object)this, "comment", buffer, (Object)theComment, this.comment != null);
        return buffer;
    }
}

