/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceContact;
import org.hl7.fhir.ConformanceDocument;
import org.hl7.fhir.ConformanceImplementation;
import org.hl7.fhir.ConformanceMessaging;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.ConformanceRest;
import org.hl7.fhir.ConformanceSoftware;
import org.hl7.fhir.ConformanceStatementKind;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.UnknownContentCode;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance", propOrder={"url", "version", "name", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "requirements", "copyright", "kind", "software", "implementation", "fhirVersion", "acceptUnknown", "format", "profile", "rest", "messaging", "document"})
public class Conformance
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Uri url;
    protected String version;
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    @XmlElement(required=true)
    protected DateTime date;
    protected String publisher;
    protected List<ConformanceContact> contact;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    protected String copyright;
    @XmlElement(required=true)
    protected ConformanceStatementKind kind;
    protected ConformanceSoftware software;
    protected ConformanceImplementation implementation;
    @XmlElement(required=true)
    protected Id fhirVersion;
    @XmlElement(required=true)
    protected UnknownContentCode acceptUnknown;
    @XmlElement(required=true)
    protected List<Code> format;
    protected List<Reference> profile;
    protected List<ConformanceRest> rest;
    protected List<ConformanceMessaging> messaging;
    protected List<ConformanceDocument> document;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<ConformanceContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ConformanceContact>();
        }
        return this.contact;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public ConformanceStatementKind getKind() {
        return this.kind;
    }

    public void setKind(ConformanceStatementKind value) {
        this.kind = value;
    }

    public ConformanceSoftware getSoftware() {
        return this.software;
    }

    public void setSoftware(ConformanceSoftware value) {
        this.software = value;
    }

    public ConformanceImplementation getImplementation() {
        return this.implementation;
    }

    public void setImplementation(ConformanceImplementation value) {
        this.implementation = value;
    }

    public Id getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(Id value) {
        this.fhirVersion = value;
    }

    public UnknownContentCode getAcceptUnknown() {
        return this.acceptUnknown;
    }

    public void setAcceptUnknown(UnknownContentCode value) {
        this.acceptUnknown = value;
    }

    public List<Code> getFormat() {
        if (this.format == null) {
            this.format = new ArrayList<Code>();
        }
        return this.format;
    }

    public List<Reference> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        return this.profile;
    }

    public List<ConformanceRest> getRest() {
        if (this.rest == null) {
            this.rest = new ArrayList<ConformanceRest>();
        }
        return this.rest;
    }

    public List<ConformanceMessaging> getMessaging() {
        if (this.messaging == null) {
            this.messaging = new ArrayList<ConformanceMessaging>();
        }
        return this.messaging;
    }

    public List<ConformanceDocument> getDocument() {
        if (this.document == null) {
            this.document = new ArrayList<ConformanceDocument>();
        }
        return this.document;
    }

    public Conformance withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public Conformance withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public Conformance withName(String value) {
        this.setName(value);
        return this;
    }

    public Conformance withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public Conformance withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public Conformance withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public Conformance withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public Conformance withContact(ConformanceContact ... values) {
        if (values != null) {
            for (ConformanceContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public Conformance withContact(Collection<ConformanceContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public Conformance withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public Conformance withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public Conformance withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public Conformance withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public Conformance withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public Conformance withKind(ConformanceStatementKind value) {
        this.setKind(value);
        return this;
    }

    public Conformance withSoftware(ConformanceSoftware value) {
        this.setSoftware(value);
        return this;
    }

    public Conformance withImplementation(ConformanceImplementation value) {
        this.setImplementation(value);
        return this;
    }

    public Conformance withFhirVersion(Id value) {
        this.setFhirVersion(value);
        return this;
    }

    public Conformance withAcceptUnknown(UnknownContentCode value) {
        this.setAcceptUnknown(value);
        return this;
    }

    public Conformance withFormat(Code ... values) {
        if (values != null) {
            for (Code value : values) {
                this.getFormat().add(value);
            }
        }
        return this;
    }

    public Conformance withFormat(Collection<Code> values) {
        if (values != null) {
            this.getFormat().addAll(values);
        }
        return this;
    }

    public Conformance withProfile(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getProfile().add(value);
            }
        }
        return this;
    }

    public Conformance withProfile(Collection<Reference> values) {
        if (values != null) {
            this.getProfile().addAll(values);
        }
        return this;
    }

    public Conformance withRest(ConformanceRest ... values) {
        if (values != null) {
            for (ConformanceRest value : values) {
                this.getRest().add(value);
            }
        }
        return this;
    }

    public Conformance withRest(Collection<ConformanceRest> values) {
        if (values != null) {
            this.getRest().addAll(values);
        }
        return this;
    }

    public Conformance withMessaging(ConformanceMessaging ... values) {
        if (values != null) {
            for (ConformanceMessaging value : values) {
                this.getMessaging().add(value);
            }
        }
        return this;
    }

    public Conformance withMessaging(Collection<ConformanceMessaging> values) {
        if (values != null) {
            this.getMessaging().addAll(values);
        }
        return this;
    }

    public Conformance withDocument(ConformanceDocument ... values) {
        if (values != null) {
            for (ConformanceDocument value : values) {
                this.getDocument().add(value);
            }
        }
        return this;
    }

    public Conformance withDocument(Collection<ConformanceDocument> values) {
        if (values != null) {
            this.getDocument().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Conformance withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Conformance withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Conformance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Conformance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Conformance withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Conformance withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Conformance withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Conformance withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Conformance that = (Conformance)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<ConformanceContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<ConformanceContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyright", (Object)lhsCopyright), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyright", (Object)rhsCopyright), (Object)lhsCopyright, (Object)rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        ConformanceStatementKind lhsKind = this.getKind();
        ConformanceStatementKind rhsKind = that.getKind();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"kind", (Object)lhsKind), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"kind", (Object)rhsKind), (Object)lhsKind, (Object)rhsKind, this.kind != null, that.kind != null)) {
            return false;
        }
        ConformanceSoftware lhsSoftware = this.getSoftware();
        ConformanceSoftware rhsSoftware = that.getSoftware();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"software", (Object)lhsSoftware), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"software", (Object)rhsSoftware), (Object)lhsSoftware, (Object)rhsSoftware, this.software != null, that.software != null)) {
            return false;
        }
        ConformanceImplementation lhsImplementation = this.getImplementation();
        ConformanceImplementation rhsImplementation = that.getImplementation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"implementation", (Object)lhsImplementation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"implementation", (Object)rhsImplementation), (Object)lhsImplementation, (Object)rhsImplementation, this.implementation != null, that.implementation != null)) {
            return false;
        }
        Id lhsFhirVersion = this.getFhirVersion();
        Id rhsFhirVersion = that.getFhirVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fhirVersion", (Object)lhsFhirVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fhirVersion", (Object)rhsFhirVersion), (Object)lhsFhirVersion, (Object)rhsFhirVersion, this.fhirVersion != null, that.fhirVersion != null)) {
            return false;
        }
        UnknownContentCode lhsAcceptUnknown = this.getAcceptUnknown();
        UnknownContentCode rhsAcceptUnknown = that.getAcceptUnknown();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"acceptUnknown", (Object)lhsAcceptUnknown), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"acceptUnknown", (Object)rhsAcceptUnknown), (Object)lhsAcceptUnknown, (Object)rhsAcceptUnknown, this.acceptUnknown != null, that.acceptUnknown != null)) {
            return false;
        }
        List<Code> lhsFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        List<Code> rhsFormat = that.format != null && !that.format.isEmpty() ? that.getFormat() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"format", lhsFormat), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"format", rhsFormat), lhsFormat, rhsFormat, this.format != null && !this.format.isEmpty(), that.format != null && !that.format.isEmpty())) {
            return false;
        }
        List<Reference> lhsProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        List<Reference> rhsProfile = that.profile != null && !that.profile.isEmpty() ? that.getProfile() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"profile", lhsProfile), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"profile", rhsProfile), lhsProfile, rhsProfile, this.profile != null && !this.profile.isEmpty(), that.profile != null && !that.profile.isEmpty())) {
            return false;
        }
        List<ConformanceRest> lhsRest = this.rest != null && !this.rest.isEmpty() ? this.getRest() : null;
        List<ConformanceRest> rhsRest = that.rest != null && !that.rest.isEmpty() ? that.getRest() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"rest", lhsRest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"rest", rhsRest), lhsRest, rhsRest, this.rest != null && !this.rest.isEmpty(), that.rest != null && !that.rest.isEmpty())) {
            return false;
        }
        List<ConformanceMessaging> lhsMessaging = this.messaging != null && !this.messaging.isEmpty() ? this.getMessaging() : null;
        List<ConformanceMessaging> rhsMessaging = that.messaging != null && !that.messaging.isEmpty() ? that.getMessaging() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"messaging", lhsMessaging), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"messaging", rhsMessaging), lhsMessaging, rhsMessaging, this.messaging != null && !this.messaging.isEmpty(), that.messaging != null && !that.messaging.isEmpty())) {
            return false;
        }
        List<ConformanceDocument> lhsDocument = this.document != null && !this.document.isEmpty() ? this.getDocument() : null;
        List<ConformanceDocument> rhsDocument = that.document != null && !that.document.isEmpty() ? that.getDocument() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"document", lhsDocument), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"document", rhsDocument), lhsDocument, rhsDocument, this.document != null && !this.document.isEmpty(), that.document != null && !that.document.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl, this.url != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental, this.experimental != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate, this.date != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher, this.publisher != null);
        List<ConformanceContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyright", (Object)theCopyright), currentHashCode, (Object)theCopyright, this.copyright != null);
        ConformanceStatementKind theKind = this.getKind();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"kind", (Object)theKind), currentHashCode, (Object)theKind, this.kind != null);
        ConformanceSoftware theSoftware = this.getSoftware();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"software", (Object)theSoftware), currentHashCode, (Object)theSoftware, this.software != null);
        ConformanceImplementation theImplementation = this.getImplementation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"implementation", (Object)theImplementation), currentHashCode, (Object)theImplementation, this.implementation != null);
        Id theFhirVersion = this.getFhirVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fhirVersion", (Object)theFhirVersion), currentHashCode, (Object)theFhirVersion, this.fhirVersion != null);
        UnknownContentCode theAcceptUnknown = this.getAcceptUnknown();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"acceptUnknown", (Object)theAcceptUnknown), currentHashCode, (Object)theAcceptUnknown, this.acceptUnknown != null);
        List<Code> theFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"format", theFormat), currentHashCode, theFormat, this.format != null && !this.format.isEmpty());
        List<Reference> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"profile", theProfile), currentHashCode, theProfile, this.profile != null && !this.profile.isEmpty());
        List<ConformanceRest> theRest = this.rest != null && !this.rest.isEmpty() ? this.getRest() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"rest", theRest), currentHashCode, theRest, this.rest != null && !this.rest.isEmpty());
        List<ConformanceMessaging> theMessaging = this.messaging != null && !this.messaging.isEmpty() ? this.getMessaging() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"messaging", theMessaging), currentHashCode, theMessaging, this.messaging != null && !this.messaging.isEmpty());
        List<ConformanceDocument> theDocument = this.document != null && !this.document.isEmpty() ? this.getDocument() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"document", theDocument), currentHashCode, theDocument, this.document != null && !this.document.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl, this.url != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental, this.experimental != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate, this.date != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher, this.publisher != null);
        List<ConformanceContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, (Object)theCopyright, this.copyright != null);
        ConformanceStatementKind theKind = this.getKind();
        strategy.appendField(locator, (Object)this, "kind", buffer, (Object)theKind, this.kind != null);
        ConformanceSoftware theSoftware = this.getSoftware();
        strategy.appendField(locator, (Object)this, "software", buffer, (Object)theSoftware, this.software != null);
        ConformanceImplementation theImplementation = this.getImplementation();
        strategy.appendField(locator, (Object)this, "implementation", buffer, (Object)theImplementation, this.implementation != null);
        Id theFhirVersion = this.getFhirVersion();
        strategy.appendField(locator, (Object)this, "fhirVersion", buffer, (Object)theFhirVersion, this.fhirVersion != null);
        UnknownContentCode theAcceptUnknown = this.getAcceptUnknown();
        strategy.appendField(locator, (Object)this, "acceptUnknown", buffer, (Object)theAcceptUnknown, this.acceptUnknown != null);
        List<Code> theFormat = this.format != null && !this.format.isEmpty() ? this.getFormat() : null;
        strategy.appendField(locator, (Object)this, "format", buffer, theFormat, this.format != null && !this.format.isEmpty());
        List<Reference> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        strategy.appendField(locator, (Object)this, "profile", buffer, theProfile, this.profile != null && !this.profile.isEmpty());
        List<ConformanceRest> theRest = this.rest != null && !this.rest.isEmpty() ? this.getRest() : null;
        strategy.appendField(locator, (Object)this, "rest", buffer, theRest, this.rest != null && !this.rest.isEmpty());
        List<ConformanceMessaging> theMessaging = this.messaging != null && !this.messaging.isEmpty() ? this.getMessaging() : null;
        strategy.appendField(locator, (Object)this, "messaging", buffer, theMessaging, this.messaging != null && !this.messaging.isEmpty());
        List<ConformanceDocument> theDocument = this.document != null && !this.document.isEmpty() ? this.getDocument() : null;
        strategy.appendField(locator, (Object)this, "document", buffer, theDocument, this.document != null && !this.document.isEmpty());
        return buffer;
    }
}

