/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.EligibilityResponseBenefitBalance;
import org.hl7.fhir.EligibilityResponseError;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.RemittanceOutcome;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EligibilityResponse", propOrder={"identifier", "requestIdentifier", "requestReference", "outcome", "disposition", "ruleset", "originalRuleset", "created", "organizationIdentifier", "organizationReference", "requestProviderIdentifier", "requestProviderReference", "requestOrganizationIdentifier", "requestOrganizationReference", "inforce", "contract", "form", "benefitBalance", "error"})
public class EligibilityResponse
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Identifier requestIdentifier;
    protected Reference requestReference;
    protected RemittanceOutcome outcome;
    protected String disposition;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Identifier organizationIdentifier;
    protected Reference organizationReference;
    protected Identifier requestProviderIdentifier;
    protected Reference requestProviderReference;
    protected Identifier requestOrganizationIdentifier;
    protected Reference requestOrganizationReference;
    protected Boolean inforce;
    protected Reference contract;
    protected Coding form;
    protected List<EligibilityResponseBenefitBalance> benefitBalance;
    protected List<EligibilityResponseError> error;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Identifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public void setRequestIdentifier(Identifier value) {
        this.requestIdentifier = value;
    }

    public Reference getRequestReference() {
        return this.requestReference;
    }

    public void setRequestReference(Reference value) {
        this.requestReference = value;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(RemittanceOutcome value) {
        this.outcome = value;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String value) {
        this.disposition = value;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Identifier getOrganizationIdentifier() {
        return this.organizationIdentifier;
    }

    public void setOrganizationIdentifier(Identifier value) {
        this.organizationIdentifier = value;
    }

    public Reference getOrganizationReference() {
        return this.organizationReference;
    }

    public void setOrganizationReference(Reference value) {
        this.organizationReference = value;
    }

    public Identifier getRequestProviderIdentifier() {
        return this.requestProviderIdentifier;
    }

    public void setRequestProviderIdentifier(Identifier value) {
        this.requestProviderIdentifier = value;
    }

    public Reference getRequestProviderReference() {
        return this.requestProviderReference;
    }

    public void setRequestProviderReference(Reference value) {
        this.requestProviderReference = value;
    }

    public Identifier getRequestOrganizationIdentifier() {
        return this.requestOrganizationIdentifier;
    }

    public void setRequestOrganizationIdentifier(Identifier value) {
        this.requestOrganizationIdentifier = value;
    }

    public Reference getRequestOrganizationReference() {
        return this.requestOrganizationReference;
    }

    public void setRequestOrganizationReference(Reference value) {
        this.requestOrganizationReference = value;
    }

    public Boolean getInforce() {
        return this.inforce;
    }

    public void setInforce(Boolean value) {
        this.inforce = value;
    }

    public Reference getContract() {
        return this.contract;
    }

    public void setContract(Reference value) {
        this.contract = value;
    }

    public Coding getForm() {
        return this.form;
    }

    public void setForm(Coding value) {
        this.form = value;
    }

    public List<EligibilityResponseBenefitBalance> getBenefitBalance() {
        if (this.benefitBalance == null) {
            this.benefitBalance = new ArrayList<EligibilityResponseBenefitBalance>();
        }
        return this.benefitBalance;
    }

    public List<EligibilityResponseError> getError() {
        if (this.error == null) {
            this.error = new ArrayList<EligibilityResponseError>();
        }
        return this.error;
    }

    public EligibilityResponse withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public EligibilityResponse withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public EligibilityResponse withRequestIdentifier(Identifier value) {
        this.setRequestIdentifier(value);
        return this;
    }

    public EligibilityResponse withRequestReference(Reference value) {
        this.setRequestReference(value);
        return this;
    }

    public EligibilityResponse withOutcome(RemittanceOutcome value) {
        this.setOutcome(value);
        return this;
    }

    public EligibilityResponse withDisposition(String value) {
        this.setDisposition(value);
        return this;
    }

    public EligibilityResponse withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public EligibilityResponse withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public EligibilityResponse withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public EligibilityResponse withOrganizationIdentifier(Identifier value) {
        this.setOrganizationIdentifier(value);
        return this;
    }

    public EligibilityResponse withOrganizationReference(Reference value) {
        this.setOrganizationReference(value);
        return this;
    }

    public EligibilityResponse withRequestProviderIdentifier(Identifier value) {
        this.setRequestProviderIdentifier(value);
        return this;
    }

    public EligibilityResponse withRequestProviderReference(Reference value) {
        this.setRequestProviderReference(value);
        return this;
    }

    public EligibilityResponse withRequestOrganizationIdentifier(Identifier value) {
        this.setRequestOrganizationIdentifier(value);
        return this;
    }

    public EligibilityResponse withRequestOrganizationReference(Reference value) {
        this.setRequestOrganizationReference(value);
        return this;
    }

    public EligibilityResponse withInforce(Boolean value) {
        this.setInforce(value);
        return this;
    }

    public EligibilityResponse withContract(Reference value) {
        this.setContract(value);
        return this;
    }

    public EligibilityResponse withForm(Coding value) {
        this.setForm(value);
        return this;
    }

    public EligibilityResponse withBenefitBalance(EligibilityResponseBenefitBalance ... values) {
        if (values != null) {
            for (EligibilityResponseBenefitBalance value : values) {
                this.getBenefitBalance().add(value);
            }
        }
        return this;
    }

    public EligibilityResponse withBenefitBalance(Collection<EligibilityResponseBenefitBalance> values) {
        if (values != null) {
            this.getBenefitBalance().addAll(values);
        }
        return this;
    }

    public EligibilityResponse withError(EligibilityResponseError ... values) {
        if (values != null) {
            for (EligibilityResponseError value : values) {
                this.getError().add(value);
            }
        }
        return this;
    }

    public EligibilityResponse withError(Collection<EligibilityResponseError> values) {
        if (values != null) {
            this.getError().addAll(values);
        }
        return this;
    }

    @Override
    public EligibilityResponse withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public EligibilityResponse withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public EligibilityResponse withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public EligibilityResponse withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EligibilityResponse withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EligibilityResponse withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EligibilityResponse withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EligibilityResponse withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public EligibilityResponse withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public EligibilityResponse withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public EligibilityResponse withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EligibilityResponse that = (EligibilityResponse)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Identifier lhsRequestIdentifier = this.getRequestIdentifier();
        Identifier rhsRequestIdentifier = that.getRequestIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestIdentifier", (Object)lhsRequestIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestIdentifier", (Object)rhsRequestIdentifier), (Object)lhsRequestIdentifier, (Object)rhsRequestIdentifier, this.requestIdentifier != null, that.requestIdentifier != null)) {
            return false;
        }
        Reference lhsRequestReference = this.getRequestReference();
        Reference rhsRequestReference = that.getRequestReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestReference", (Object)lhsRequestReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestReference", (Object)rhsRequestReference), (Object)lhsRequestReference, (Object)rhsRequestReference, this.requestReference != null, that.requestReference != null)) {
            return false;
        }
        RemittanceOutcome lhsOutcome = this.getOutcome();
        RemittanceOutcome rhsOutcome = that.getOutcome();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"outcome", (Object)lhsOutcome), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"outcome", (Object)rhsOutcome), (Object)lhsOutcome, (Object)rhsOutcome, this.outcome != null, that.outcome != null)) {
            return false;
        }
        String lhsDisposition = this.getDisposition();
        String rhsDisposition = that.getDisposition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"disposition", (Object)lhsDisposition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"disposition", (Object)rhsDisposition), (Object)lhsDisposition, (Object)rhsDisposition, this.disposition != null, that.disposition != null)) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"ruleset", (Object)lhsRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"ruleset", (Object)rhsRuleset), (Object)lhsRuleset, (Object)rhsRuleset, this.ruleset != null, that.ruleset != null)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"originalRuleset", (Object)lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"originalRuleset", (Object)rhsOriginalRuleset), (Object)lhsOriginalRuleset, (Object)rhsOriginalRuleset, this.originalRuleset != null, that.originalRuleset != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Identifier lhsOrganizationIdentifier = this.getOrganizationIdentifier();
        Identifier rhsOrganizationIdentifier = that.getOrganizationIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"organizationIdentifier", (Object)lhsOrganizationIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"organizationIdentifier", (Object)rhsOrganizationIdentifier), (Object)lhsOrganizationIdentifier, (Object)rhsOrganizationIdentifier, this.organizationIdentifier != null, that.organizationIdentifier != null)) {
            return false;
        }
        Reference lhsOrganizationReference = this.getOrganizationReference();
        Reference rhsOrganizationReference = that.getOrganizationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"organizationReference", (Object)lhsOrganizationReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"organizationReference", (Object)rhsOrganizationReference), (Object)lhsOrganizationReference, (Object)rhsOrganizationReference, this.organizationReference != null, that.organizationReference != null)) {
            return false;
        }
        Identifier lhsRequestProviderIdentifier = this.getRequestProviderIdentifier();
        Identifier rhsRequestProviderIdentifier = that.getRequestProviderIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestProviderIdentifier", (Object)lhsRequestProviderIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestProviderIdentifier", (Object)rhsRequestProviderIdentifier), (Object)lhsRequestProviderIdentifier, (Object)rhsRequestProviderIdentifier, this.requestProviderIdentifier != null, that.requestProviderIdentifier != null)) {
            return false;
        }
        Reference lhsRequestProviderReference = this.getRequestProviderReference();
        Reference rhsRequestProviderReference = that.getRequestProviderReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestProviderReference", (Object)lhsRequestProviderReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestProviderReference", (Object)rhsRequestProviderReference), (Object)lhsRequestProviderReference, (Object)rhsRequestProviderReference, this.requestProviderReference != null, that.requestProviderReference != null)) {
            return false;
        }
        Identifier lhsRequestOrganizationIdentifier = this.getRequestOrganizationIdentifier();
        Identifier rhsRequestOrganizationIdentifier = that.getRequestOrganizationIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestOrganizationIdentifier", (Object)lhsRequestOrganizationIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestOrganizationIdentifier", (Object)rhsRequestOrganizationIdentifier), (Object)lhsRequestOrganizationIdentifier, (Object)rhsRequestOrganizationIdentifier, this.requestOrganizationIdentifier != null, that.requestOrganizationIdentifier != null)) {
            return false;
        }
        Reference lhsRequestOrganizationReference = this.getRequestOrganizationReference();
        Reference rhsRequestOrganizationReference = that.getRequestOrganizationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestOrganizationReference", (Object)lhsRequestOrganizationReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestOrganizationReference", (Object)rhsRequestOrganizationReference), (Object)lhsRequestOrganizationReference, (Object)rhsRequestOrganizationReference, this.requestOrganizationReference != null, that.requestOrganizationReference != null)) {
            return false;
        }
        Boolean lhsInforce = this.getInforce();
        Boolean rhsInforce = that.getInforce();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"inforce", (Object)lhsInforce), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"inforce", (Object)rhsInforce), (Object)lhsInforce, (Object)rhsInforce, this.inforce != null, that.inforce != null)) {
            return false;
        }
        Reference lhsContract = this.getContract();
        Reference rhsContract = that.getContract();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contract", (Object)lhsContract), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contract", (Object)rhsContract), (Object)lhsContract, (Object)rhsContract, this.contract != null, that.contract != null)) {
            return false;
        }
        Coding lhsForm = this.getForm();
        Coding rhsForm = that.getForm();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"form", (Object)lhsForm), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"form", (Object)rhsForm), (Object)lhsForm, (Object)rhsForm, this.form != null, that.form != null)) {
            return false;
        }
        List<EligibilityResponseBenefitBalance> lhsBenefitBalance = this.benefitBalance != null && !this.benefitBalance.isEmpty() ? this.getBenefitBalance() : null;
        List<EligibilityResponseBenefitBalance> rhsBenefitBalance = that.benefitBalance != null && !that.benefitBalance.isEmpty() ? that.getBenefitBalance() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"benefitBalance", lhsBenefitBalance), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"benefitBalance", rhsBenefitBalance), lhsBenefitBalance, rhsBenefitBalance, this.benefitBalance != null && !this.benefitBalance.isEmpty(), that.benefitBalance != null && !that.benefitBalance.isEmpty())) {
            return false;
        }
        List<EligibilityResponseError> lhsError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        List<EligibilityResponseError> rhsError = that.error != null && !that.error.isEmpty() ? that.getError() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"error", lhsError), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"error", rhsError), lhsError, rhsError, this.error != null && !this.error.isEmpty(), that.error != null && !that.error.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Identifier theRequestIdentifier = this.getRequestIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestIdentifier", (Object)theRequestIdentifier), currentHashCode, (Object)theRequestIdentifier, this.requestIdentifier != null);
        Reference theRequestReference = this.getRequestReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestReference", (Object)theRequestReference), currentHashCode, (Object)theRequestReference, this.requestReference != null);
        RemittanceOutcome theOutcome = this.getOutcome();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"outcome", (Object)theOutcome), currentHashCode, (Object)theOutcome, this.outcome != null);
        String theDisposition = this.getDisposition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"disposition", (Object)theDisposition), currentHashCode, (Object)theDisposition, this.disposition != null);
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"ruleset", (Object)theRuleset), currentHashCode, (Object)theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"originalRuleset", (Object)theOriginalRuleset), currentHashCode, (Object)theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated, this.created != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"organizationIdentifier", (Object)theOrganizationIdentifier), currentHashCode, (Object)theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"organizationReference", (Object)theOrganizationReference), currentHashCode, (Object)theOrganizationReference, this.organizationReference != null);
        Identifier theRequestProviderIdentifier = this.getRequestProviderIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestProviderIdentifier", (Object)theRequestProviderIdentifier), currentHashCode, (Object)theRequestProviderIdentifier, this.requestProviderIdentifier != null);
        Reference theRequestProviderReference = this.getRequestProviderReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestProviderReference", (Object)theRequestProviderReference), currentHashCode, (Object)theRequestProviderReference, this.requestProviderReference != null);
        Identifier theRequestOrganizationIdentifier = this.getRequestOrganizationIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestOrganizationIdentifier", (Object)theRequestOrganizationIdentifier), currentHashCode, (Object)theRequestOrganizationIdentifier, this.requestOrganizationIdentifier != null);
        Reference theRequestOrganizationReference = this.getRequestOrganizationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestOrganizationReference", (Object)theRequestOrganizationReference), currentHashCode, (Object)theRequestOrganizationReference, this.requestOrganizationReference != null);
        Boolean theInforce = this.getInforce();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"inforce", (Object)theInforce), currentHashCode, (Object)theInforce, this.inforce != null);
        Reference theContract = this.getContract();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contract", (Object)theContract), currentHashCode, (Object)theContract, this.contract != null);
        Coding theForm = this.getForm();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"form", (Object)theForm), currentHashCode, (Object)theForm, this.form != null);
        List<EligibilityResponseBenefitBalance> theBenefitBalance = this.benefitBalance != null && !this.benefitBalance.isEmpty() ? this.getBenefitBalance() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"benefitBalance", theBenefitBalance), currentHashCode, theBenefitBalance, this.benefitBalance != null && !this.benefitBalance.isEmpty());
        List<EligibilityResponseError> theError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"error", theError), currentHashCode, theError, this.error != null && !this.error.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Identifier theRequestIdentifier = this.getRequestIdentifier();
        strategy.appendField(locator, (Object)this, "requestIdentifier", buffer, (Object)theRequestIdentifier, this.requestIdentifier != null);
        Reference theRequestReference = this.getRequestReference();
        strategy.appendField(locator, (Object)this, "requestReference", buffer, (Object)theRequestReference, this.requestReference != null);
        RemittanceOutcome theOutcome = this.getOutcome();
        strategy.appendField(locator, (Object)this, "outcome", buffer, (Object)theOutcome, this.outcome != null);
        String theDisposition = this.getDisposition();
        strategy.appendField(locator, (Object)this, "disposition", buffer, (Object)theDisposition, this.disposition != null);
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, (Object)theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, (Object)theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated, this.created != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        strategy.appendField(locator, (Object)this, "organizationIdentifier", buffer, (Object)theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        strategy.appendField(locator, (Object)this, "organizationReference", buffer, (Object)theOrganizationReference, this.organizationReference != null);
        Identifier theRequestProviderIdentifier = this.getRequestProviderIdentifier();
        strategy.appendField(locator, (Object)this, "requestProviderIdentifier", buffer, (Object)theRequestProviderIdentifier, this.requestProviderIdentifier != null);
        Reference theRequestProviderReference = this.getRequestProviderReference();
        strategy.appendField(locator, (Object)this, "requestProviderReference", buffer, (Object)theRequestProviderReference, this.requestProviderReference != null);
        Identifier theRequestOrganizationIdentifier = this.getRequestOrganizationIdentifier();
        strategy.appendField(locator, (Object)this, "requestOrganizationIdentifier", buffer, (Object)theRequestOrganizationIdentifier, this.requestOrganizationIdentifier != null);
        Reference theRequestOrganizationReference = this.getRequestOrganizationReference();
        strategy.appendField(locator, (Object)this, "requestOrganizationReference", buffer, (Object)theRequestOrganizationReference, this.requestOrganizationReference != null);
        Boolean theInforce = this.getInforce();
        strategy.appendField(locator, (Object)this, "inforce", buffer, (Object)theInforce, this.inforce != null);
        Reference theContract = this.getContract();
        strategy.appendField(locator, (Object)this, "contract", buffer, (Object)theContract, this.contract != null);
        Coding theForm = this.getForm();
        strategy.appendField(locator, (Object)this, "form", buffer, (Object)theForm, this.form != null);
        List<EligibilityResponseBenefitBalance> theBenefitBalance = this.benefitBalance != null && !this.benefitBalance.isEmpty() ? this.getBenefitBalance() : null;
        strategy.appendField(locator, (Object)this, "benefitBalance", buffer, theBenefitBalance, this.benefitBalance != null && !this.benefitBalance.isEmpty());
        List<EligibilityResponseError> theError = this.error != null && !this.error.isEmpty() ? this.getError() : null;
        strategy.appendField(locator, (Object)this, "error", buffer, theError, this.error != null && !this.error.isEmpty());
        return buffer;
    }
}

