/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.ImmunizationExplanation;
import org.hl7.fhir.ImmunizationReaction;
import org.hl7.fhir.ImmunizationVaccinationProtocol;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SimpleQuantity;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Immunization", propOrder={"identifier", "status", "date", "vaccineCode", "patient", "wasNotGiven", "reported", "performer", "requester", "encounter", "manufacturer", "location", "lotNumber", "expirationDate", "site", "route", "doseQuantity", "note", "explanation", "reaction", "vaccinationProtocol"})
public class Immunization
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Code status;
    protected DateTime date;
    @XmlElement(required=true)
    protected CodeableConcept vaccineCode;
    @XmlElement(required=true)
    protected Reference patient;
    @XmlElement(required=true)
    protected Boolean wasNotGiven;
    @XmlElement(required=true)
    protected Boolean reported;
    protected Reference performer;
    protected Reference requester;
    protected Reference encounter;
    protected Reference manufacturer;
    protected Reference location;
    protected String lotNumber;
    protected Date expirationDate;
    protected CodeableConcept site;
    protected CodeableConcept route;
    protected SimpleQuantity doseQuantity;
    protected List<Annotation> note;
    protected ImmunizationExplanation explanation;
    protected List<ImmunizationReaction> reaction;
    protected List<ImmunizationVaccinationProtocol> vaccinationProtocol;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Code getStatus() {
        return this.status;
    }

    public void setStatus(Code value) {
        this.status = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public CodeableConcept getVaccineCode() {
        return this.vaccineCode;
    }

    public void setVaccineCode(CodeableConcept value) {
        this.vaccineCode = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Boolean getWasNotGiven() {
        return this.wasNotGiven;
    }

    public void setWasNotGiven(Boolean value) {
        this.wasNotGiven = value;
    }

    public Boolean getReported() {
        return this.reported;
    }

    public void setReported(Boolean value) {
        this.reported = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public void setRequester(Reference value) {
        this.requester = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(Reference value) {
        this.manufacturer = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public String getLotNumber() {
        return this.lotNumber;
    }

    public void setLotNumber(String value) {
        this.lotNumber = value;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date value) {
        this.expirationDate = value;
    }

    public CodeableConcept getSite() {
        return this.site;
    }

    public void setSite(CodeableConcept value) {
        this.site = value;
    }

    public CodeableConcept getRoute() {
        return this.route;
    }

    public void setRoute(CodeableConcept value) {
        this.route = value;
    }

    public SimpleQuantity getDoseQuantity() {
        return this.doseQuantity;
    }

    public void setDoseQuantity(SimpleQuantity value) {
        this.doseQuantity = value;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ImmunizationExplanation getExplanation() {
        return this.explanation;
    }

    public void setExplanation(ImmunizationExplanation value) {
        this.explanation = value;
    }

    public List<ImmunizationReaction> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReaction>();
        }
        return this.reaction;
    }

    public List<ImmunizationVaccinationProtocol> getVaccinationProtocol() {
        if (this.vaccinationProtocol == null) {
            this.vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocol>();
        }
        return this.vaccinationProtocol;
    }

    public Immunization withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Immunization withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Immunization withStatus(Code value) {
        this.setStatus(value);
        return this;
    }

    public Immunization withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public Immunization withVaccineCode(CodeableConcept value) {
        this.setVaccineCode(value);
        return this;
    }

    public Immunization withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Immunization withWasNotGiven(Boolean value) {
        this.setWasNotGiven(value);
        return this;
    }

    public Immunization withReported(Boolean value) {
        this.setReported(value);
        return this;
    }

    public Immunization withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public Immunization withRequester(Reference value) {
        this.setRequester(value);
        return this;
    }

    public Immunization withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Immunization withManufacturer(Reference value) {
        this.setManufacturer(value);
        return this;
    }

    public Immunization withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public Immunization withLotNumber(String value) {
        this.setLotNumber(value);
        return this;
    }

    public Immunization withExpirationDate(Date value) {
        this.setExpirationDate(value);
        return this;
    }

    public Immunization withSite(CodeableConcept value) {
        this.setSite(value);
        return this;
    }

    public Immunization withRoute(CodeableConcept value) {
        this.setRoute(value);
        return this;
    }

    public Immunization withDoseQuantity(SimpleQuantity value) {
        this.setDoseQuantity(value);
        return this;
    }

    public Immunization withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public Immunization withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public Immunization withExplanation(ImmunizationExplanation value) {
        this.setExplanation(value);
        return this;
    }

    public Immunization withReaction(ImmunizationReaction ... values) {
        if (values != null) {
            for (ImmunizationReaction value : values) {
                this.getReaction().add(value);
            }
        }
        return this;
    }

    public Immunization withReaction(Collection<ImmunizationReaction> values) {
        if (values != null) {
            this.getReaction().addAll(values);
        }
        return this;
    }

    public Immunization withVaccinationProtocol(ImmunizationVaccinationProtocol ... values) {
        if (values != null) {
            for (ImmunizationVaccinationProtocol value : values) {
                this.getVaccinationProtocol().add(value);
            }
        }
        return this;
    }

    public Immunization withVaccinationProtocol(Collection<ImmunizationVaccinationProtocol> values) {
        if (values != null) {
            this.getVaccinationProtocol().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Immunization withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Immunization withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Immunization withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Immunization withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Immunization withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Immunization withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Immunization withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Immunization that = (Immunization)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Code lhsStatus = this.getStatus();
        Code rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        CodeableConcept lhsVaccineCode = this.getVaccineCode();
        CodeableConcept rhsVaccineCode = that.getVaccineCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"vaccineCode", (Object)lhsVaccineCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"vaccineCode", (Object)rhsVaccineCode), (Object)lhsVaccineCode, (Object)rhsVaccineCode, this.vaccineCode != null, that.vaccineCode != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Boolean lhsWasNotGiven = this.getWasNotGiven();
        Boolean rhsWasNotGiven = that.getWasNotGiven();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"wasNotGiven", (Object)lhsWasNotGiven), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"wasNotGiven", (Object)rhsWasNotGiven), (Object)lhsWasNotGiven, (Object)rhsWasNotGiven, this.wasNotGiven != null, that.wasNotGiven != null)) {
            return false;
        }
        Boolean lhsReported = this.getReported();
        Boolean rhsReported = that.getReported();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reported", (Object)lhsReported), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reported", (Object)rhsReported), (Object)lhsReported, (Object)rhsReported, this.reported != null, that.reported != null)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", (Object)lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", (Object)rhsPerformer), (Object)lhsPerformer, (Object)rhsPerformer, this.performer != null, that.performer != null)) {
            return false;
        }
        Reference lhsRequester = this.getRequester();
        Reference rhsRequester = that.getRequester();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requester", (Object)lhsRequester), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requester", (Object)rhsRequester), (Object)lhsRequester, (Object)rhsRequester, this.requester != null, that.requester != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        Reference lhsManufacturer = this.getManufacturer();
        Reference rhsManufacturer = that.getManufacturer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"manufacturer", (Object)lhsManufacturer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"manufacturer", (Object)rhsManufacturer), (Object)lhsManufacturer, (Object)rhsManufacturer, this.manufacturer != null, that.manufacturer != null)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"location", (Object)lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"location", (Object)rhsLocation), (Object)lhsLocation, (Object)rhsLocation, this.location != null, that.location != null)) {
            return false;
        }
        String lhsLotNumber = this.getLotNumber();
        String rhsLotNumber = that.getLotNumber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"lotNumber", (Object)lhsLotNumber), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"lotNumber", (Object)rhsLotNumber), (Object)lhsLotNumber, (Object)rhsLotNumber, this.lotNumber != null, that.lotNumber != null)) {
            return false;
        }
        Date lhsExpirationDate = this.getExpirationDate();
        Date rhsExpirationDate = that.getExpirationDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"expirationDate", (Object)lhsExpirationDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"expirationDate", (Object)rhsExpirationDate), (Object)lhsExpirationDate, (Object)rhsExpirationDate, this.expirationDate != null, that.expirationDate != null)) {
            return false;
        }
        CodeableConcept lhsSite = this.getSite();
        CodeableConcept rhsSite = that.getSite();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"site", (Object)lhsSite), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"site", (Object)rhsSite), (Object)lhsSite, (Object)rhsSite, this.site != null, that.site != null)) {
            return false;
        }
        CodeableConcept lhsRoute = this.getRoute();
        CodeableConcept rhsRoute = that.getRoute();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"route", (Object)lhsRoute), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"route", (Object)rhsRoute), (Object)lhsRoute, (Object)rhsRoute, this.route != null, that.route != null)) {
            return false;
        }
        SimpleQuantity lhsDoseQuantity = this.getDoseQuantity();
        SimpleQuantity rhsDoseQuantity = that.getDoseQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"doseQuantity", (Object)lhsDoseQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"doseQuantity", (Object)rhsDoseQuantity), (Object)lhsDoseQuantity, (Object)rhsDoseQuantity, this.doseQuantity != null, that.doseQuantity != null)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"note", lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        ImmunizationExplanation lhsExplanation = this.getExplanation();
        ImmunizationExplanation rhsExplanation = that.getExplanation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"explanation", (Object)lhsExplanation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"explanation", (Object)rhsExplanation), (Object)lhsExplanation, (Object)rhsExplanation, this.explanation != null, that.explanation != null)) {
            return false;
        }
        List<ImmunizationReaction> lhsReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        List<ImmunizationReaction> rhsReaction = that.reaction != null && !that.reaction.isEmpty() ? that.getReaction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reaction", lhsReaction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reaction", rhsReaction), lhsReaction, rhsReaction, this.reaction != null && !this.reaction.isEmpty(), that.reaction != null && !that.reaction.isEmpty())) {
            return false;
        }
        List<ImmunizationVaccinationProtocol> lhsVaccinationProtocol = this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty() ? this.getVaccinationProtocol() : null;
        List<ImmunizationVaccinationProtocol> rhsVaccinationProtocol = that.vaccinationProtocol != null && !that.vaccinationProtocol.isEmpty() ? that.getVaccinationProtocol() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"vaccinationProtocol", lhsVaccinationProtocol), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"vaccinationProtocol", rhsVaccinationProtocol), lhsVaccinationProtocol, rhsVaccinationProtocol, this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty(), that.vaccinationProtocol != null && !that.vaccinationProtocol.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Code theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate, this.date != null);
        CodeableConcept theVaccineCode = this.getVaccineCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"vaccineCode", (Object)theVaccineCode), currentHashCode, (Object)theVaccineCode, this.vaccineCode != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        Boolean theWasNotGiven = this.getWasNotGiven();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"wasNotGiven", (Object)theWasNotGiven), currentHashCode, (Object)theWasNotGiven, this.wasNotGiven != null);
        Boolean theReported = this.getReported();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reported", (Object)theReported), currentHashCode, (Object)theReported, this.reported != null);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", (Object)thePerformer), currentHashCode, (Object)thePerformer, this.performer != null);
        Reference theRequester = this.getRequester();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requester", (Object)theRequester), currentHashCode, (Object)theRequester, this.requester != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter, this.encounter != null);
        Reference theManufacturer = this.getManufacturer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"manufacturer", (Object)theManufacturer), currentHashCode, (Object)theManufacturer, this.manufacturer != null);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"location", (Object)theLocation), currentHashCode, (Object)theLocation, this.location != null);
        String theLotNumber = this.getLotNumber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"lotNumber", (Object)theLotNumber), currentHashCode, (Object)theLotNumber, this.lotNumber != null);
        Date theExpirationDate = this.getExpirationDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"expirationDate", (Object)theExpirationDate), currentHashCode, (Object)theExpirationDate, this.expirationDate != null);
        CodeableConcept theSite = this.getSite();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"site", (Object)theSite), currentHashCode, (Object)theSite, this.site != null);
        CodeableConcept theRoute = this.getRoute();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"route", (Object)theRoute), currentHashCode, (Object)theRoute, this.route != null);
        SimpleQuantity theDoseQuantity = this.getDoseQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"doseQuantity", (Object)theDoseQuantity), currentHashCode, (Object)theDoseQuantity, this.doseQuantity != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        ImmunizationExplanation theExplanation = this.getExplanation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"explanation", (Object)theExplanation), currentHashCode, (Object)theExplanation, this.explanation != null);
        List<ImmunizationReaction> theReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reaction", theReaction), currentHashCode, theReaction, this.reaction != null && !this.reaction.isEmpty());
        List<ImmunizationVaccinationProtocol> theVaccinationProtocol = this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty() ? this.getVaccinationProtocol() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"vaccinationProtocol", theVaccinationProtocol), currentHashCode, theVaccinationProtocol, this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Code theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate, this.date != null);
        CodeableConcept theVaccineCode = this.getVaccineCode();
        strategy.appendField(locator, (Object)this, "vaccineCode", buffer, (Object)theVaccineCode, this.vaccineCode != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        Boolean theWasNotGiven = this.getWasNotGiven();
        strategy.appendField(locator, (Object)this, "wasNotGiven", buffer, (Object)theWasNotGiven, this.wasNotGiven != null);
        Boolean theReported = this.getReported();
        strategy.appendField(locator, (Object)this, "reported", buffer, (Object)theReported, this.reported != null);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, (Object)thePerformer, this.performer != null);
        Reference theRequester = this.getRequester();
        strategy.appendField(locator, (Object)this, "requester", buffer, (Object)theRequester, this.requester != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter, this.encounter != null);
        Reference theManufacturer = this.getManufacturer();
        strategy.appendField(locator, (Object)this, "manufacturer", buffer, (Object)theManufacturer, this.manufacturer != null);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, (Object)theLocation, this.location != null);
        String theLotNumber = this.getLotNumber();
        strategy.appendField(locator, (Object)this, "lotNumber", buffer, (Object)theLotNumber, this.lotNumber != null);
        Date theExpirationDate = this.getExpirationDate();
        strategy.appendField(locator, (Object)this, "expirationDate", buffer, (Object)theExpirationDate, this.expirationDate != null);
        CodeableConcept theSite = this.getSite();
        strategy.appendField(locator, (Object)this, "site", buffer, (Object)theSite, this.site != null);
        CodeableConcept theRoute = this.getRoute();
        strategy.appendField(locator, (Object)this, "route", buffer, (Object)theRoute, this.route != null);
        SimpleQuantity theDoseQuantity = this.getDoseQuantity();
        strategy.appendField(locator, (Object)this, "doseQuantity", buffer, (Object)theDoseQuantity, this.doseQuantity != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        ImmunizationExplanation theExplanation = this.getExplanation();
        strategy.appendField(locator, (Object)this, "explanation", buffer, (Object)theExplanation, this.explanation != null);
        List<ImmunizationReaction> theReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        strategy.appendField(locator, (Object)this, "reaction", buffer, theReaction, this.reaction != null && !this.reaction.isEmpty());
        List<ImmunizationVaccinationProtocol> theVaccinationProtocol = this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty() ? this.getVaccinationProtocol() : null;
        strategy.appendField(locator, (Object)this, "vaccinationProtocol", buffer, theVaccinationProtocol, this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty());
        return buffer;
    }
}

