/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.ConditionalDeleteStatus;
import org.hl7.fhir.ConformanceInteraction;
import org.hl7.fhir.ConformanceSearchParam;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceVersionPolicy;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance.Resource", propOrder={"type", "profile", "interaction", "versioning", "readHistory", "updateCreate", "conditionalCreate", "conditionalUpdate", "conditionalDelete", "searchInclude", "searchRevInclude", "searchParam"})
public class ConformanceResource
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Code type;
    protected Reference profile;
    @XmlElement(required=true)
    protected List<ConformanceInteraction> interaction;
    protected ResourceVersionPolicy versioning;
    protected Boolean readHistory;
    protected Boolean updateCreate;
    protected Boolean conditionalCreate;
    protected Boolean conditionalUpdate;
    protected ConditionalDeleteStatus conditionalDelete;
    protected List<String> searchInclude;
    protected List<String> searchRevInclude;
    protected List<ConformanceSearchParam> searchParam;

    public Code getType() {
        return this.type;
    }

    public void setType(Code value) {
        this.type = value;
    }

    public Reference getProfile() {
        return this.profile;
    }

    public void setProfile(Reference value) {
        this.profile = value;
    }

    public List<ConformanceInteraction> getInteraction() {
        if (this.interaction == null) {
            this.interaction = new ArrayList<ConformanceInteraction>();
        }
        return this.interaction;
    }

    public ResourceVersionPolicy getVersioning() {
        return this.versioning;
    }

    public void setVersioning(ResourceVersionPolicy value) {
        this.versioning = value;
    }

    public Boolean getReadHistory() {
        return this.readHistory;
    }

    public void setReadHistory(Boolean value) {
        this.readHistory = value;
    }

    public Boolean getUpdateCreate() {
        return this.updateCreate;
    }

    public void setUpdateCreate(Boolean value) {
        this.updateCreate = value;
    }

    public Boolean getConditionalCreate() {
        return this.conditionalCreate;
    }

    public void setConditionalCreate(Boolean value) {
        this.conditionalCreate = value;
    }

    public Boolean getConditionalUpdate() {
        return this.conditionalUpdate;
    }

    public void setConditionalUpdate(Boolean value) {
        this.conditionalUpdate = value;
    }

    public ConditionalDeleteStatus getConditionalDelete() {
        return this.conditionalDelete;
    }

    public void setConditionalDelete(ConditionalDeleteStatus value) {
        this.conditionalDelete = value;
    }

    public List<String> getSearchInclude() {
        if (this.searchInclude == null) {
            this.searchInclude = new ArrayList<String>();
        }
        return this.searchInclude;
    }

    public List<String> getSearchRevInclude() {
        if (this.searchRevInclude == null) {
            this.searchRevInclude = new ArrayList<String>();
        }
        return this.searchRevInclude;
    }

    public List<ConformanceSearchParam> getSearchParam() {
        if (this.searchParam == null) {
            this.searchParam = new ArrayList<ConformanceSearchParam>();
        }
        return this.searchParam;
    }

    public ConformanceResource withType(Code value) {
        this.setType(value);
        return this;
    }

    public ConformanceResource withProfile(Reference value) {
        this.setProfile(value);
        return this;
    }

    public ConformanceResource withInteraction(ConformanceInteraction ... values) {
        if (values != null) {
            for (ConformanceInteraction value : values) {
                this.getInteraction().add(value);
            }
        }
        return this;
    }

    public ConformanceResource withInteraction(Collection<ConformanceInteraction> values) {
        if (values != null) {
            this.getInteraction().addAll(values);
        }
        return this;
    }

    public ConformanceResource withVersioning(ResourceVersionPolicy value) {
        this.setVersioning(value);
        return this;
    }

    public ConformanceResource withReadHistory(Boolean value) {
        this.setReadHistory(value);
        return this;
    }

    public ConformanceResource withUpdateCreate(Boolean value) {
        this.setUpdateCreate(value);
        return this;
    }

    public ConformanceResource withConditionalCreate(Boolean value) {
        this.setConditionalCreate(value);
        return this;
    }

    public ConformanceResource withConditionalUpdate(Boolean value) {
        this.setConditionalUpdate(value);
        return this;
    }

    public ConformanceResource withConditionalDelete(ConditionalDeleteStatus value) {
        this.setConditionalDelete(value);
        return this;
    }

    public ConformanceResource withSearchInclude(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getSearchInclude().add(value);
            }
        }
        return this;
    }

    public ConformanceResource withSearchInclude(Collection<String> values) {
        if (values != null) {
            this.getSearchInclude().addAll(values);
        }
        return this;
    }

    public ConformanceResource withSearchRevInclude(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getSearchRevInclude().add(value);
            }
        }
        return this;
    }

    public ConformanceResource withSearchRevInclude(Collection<String> values) {
        if (values != null) {
            this.getSearchRevInclude().addAll(values);
        }
        return this;
    }

    public ConformanceResource withSearchParam(ConformanceSearchParam ... values) {
        if (values != null) {
            for (ConformanceSearchParam value : values) {
                this.getSearchParam().add(value);
            }
        }
        return this;
    }

    public ConformanceResource withSearchParam(Collection<ConformanceSearchParam> values) {
        if (values != null) {
            this.getSearchParam().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceResource withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceResource withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceResource withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceResource withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceResource withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConformanceResource that = (ConformanceResource)object;
        Code lhsType = this.getType();
        Code rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        Reference lhsProfile = this.getProfile();
        Reference rhsProfile = that.getProfile();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"profile", (Object)lhsProfile), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"profile", (Object)rhsProfile), (Object)lhsProfile, (Object)rhsProfile, this.profile != null, that.profile != null)) {
            return false;
        }
        List<ConformanceInteraction> lhsInteraction = this.interaction != null && !this.interaction.isEmpty() ? this.getInteraction() : null;
        List<ConformanceInteraction> rhsInteraction = that.interaction != null && !that.interaction.isEmpty() ? that.getInteraction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"interaction", lhsInteraction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"interaction", rhsInteraction), lhsInteraction, rhsInteraction, this.interaction != null && !this.interaction.isEmpty(), that.interaction != null && !that.interaction.isEmpty())) {
            return false;
        }
        ResourceVersionPolicy lhsVersioning = this.getVersioning();
        ResourceVersionPolicy rhsVersioning = that.getVersioning();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"versioning", (Object)lhsVersioning), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"versioning", (Object)rhsVersioning), (Object)lhsVersioning, (Object)rhsVersioning, this.versioning != null, that.versioning != null)) {
            return false;
        }
        Boolean lhsReadHistory = this.getReadHistory();
        Boolean rhsReadHistory = that.getReadHistory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"readHistory", (Object)lhsReadHistory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"readHistory", (Object)rhsReadHistory), (Object)lhsReadHistory, (Object)rhsReadHistory, this.readHistory != null, that.readHistory != null)) {
            return false;
        }
        Boolean lhsUpdateCreate = this.getUpdateCreate();
        Boolean rhsUpdateCreate = that.getUpdateCreate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"updateCreate", (Object)lhsUpdateCreate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"updateCreate", (Object)rhsUpdateCreate), (Object)lhsUpdateCreate, (Object)rhsUpdateCreate, this.updateCreate != null, that.updateCreate != null)) {
            return false;
        }
        Boolean lhsConditionalCreate = this.getConditionalCreate();
        Boolean rhsConditionalCreate = that.getConditionalCreate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"conditionalCreate", (Object)lhsConditionalCreate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"conditionalCreate", (Object)rhsConditionalCreate), (Object)lhsConditionalCreate, (Object)rhsConditionalCreate, this.conditionalCreate != null, that.conditionalCreate != null)) {
            return false;
        }
        Boolean lhsConditionalUpdate = this.getConditionalUpdate();
        Boolean rhsConditionalUpdate = that.getConditionalUpdate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"conditionalUpdate", (Object)lhsConditionalUpdate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"conditionalUpdate", (Object)rhsConditionalUpdate), (Object)lhsConditionalUpdate, (Object)rhsConditionalUpdate, this.conditionalUpdate != null, that.conditionalUpdate != null)) {
            return false;
        }
        ConditionalDeleteStatus lhsConditionalDelete = this.getConditionalDelete();
        ConditionalDeleteStatus rhsConditionalDelete = that.getConditionalDelete();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"conditionalDelete", (Object)lhsConditionalDelete), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"conditionalDelete", (Object)rhsConditionalDelete), (Object)lhsConditionalDelete, (Object)rhsConditionalDelete, this.conditionalDelete != null, that.conditionalDelete != null)) {
            return false;
        }
        List<String> lhsSearchInclude = this.searchInclude != null && !this.searchInclude.isEmpty() ? this.getSearchInclude() : null;
        List<String> rhsSearchInclude = that.searchInclude != null && !that.searchInclude.isEmpty() ? that.getSearchInclude() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"searchInclude", lhsSearchInclude), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"searchInclude", rhsSearchInclude), lhsSearchInclude, rhsSearchInclude, this.searchInclude != null && !this.searchInclude.isEmpty(), that.searchInclude != null && !that.searchInclude.isEmpty())) {
            return false;
        }
        List<String> lhsSearchRevInclude = this.searchRevInclude != null && !this.searchRevInclude.isEmpty() ? this.getSearchRevInclude() : null;
        List<String> rhsSearchRevInclude = that.searchRevInclude != null && !that.searchRevInclude.isEmpty() ? that.getSearchRevInclude() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"searchRevInclude", lhsSearchRevInclude), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"searchRevInclude", rhsSearchRevInclude), lhsSearchRevInclude, rhsSearchRevInclude, this.searchRevInclude != null && !this.searchRevInclude.isEmpty(), that.searchRevInclude != null && !that.searchRevInclude.isEmpty())) {
            return false;
        }
        List<ConformanceSearchParam> lhsSearchParam = this.searchParam != null && !this.searchParam.isEmpty() ? this.getSearchParam() : null;
        List<ConformanceSearchParam> rhsSearchParam = that.searchParam != null && !that.searchParam.isEmpty() ? that.getSearchParam() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"searchParam", lhsSearchParam), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"searchParam", rhsSearchParam), lhsSearchParam, rhsSearchParam, this.searchParam != null && !this.searchParam.isEmpty(), that.searchParam != null && !that.searchParam.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Code theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        Reference theProfile = this.getProfile();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"profile", (Object)theProfile), currentHashCode, (Object)theProfile, this.profile != null);
        List<ConformanceInteraction> theInteraction = this.interaction != null && !this.interaction.isEmpty() ? this.getInteraction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"interaction", theInteraction), currentHashCode, theInteraction, this.interaction != null && !this.interaction.isEmpty());
        ResourceVersionPolicy theVersioning = this.getVersioning();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"versioning", (Object)theVersioning), currentHashCode, (Object)theVersioning, this.versioning != null);
        Boolean theReadHistory = this.getReadHistory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"readHistory", (Object)theReadHistory), currentHashCode, (Object)theReadHistory, this.readHistory != null);
        Boolean theUpdateCreate = this.getUpdateCreate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"updateCreate", (Object)theUpdateCreate), currentHashCode, (Object)theUpdateCreate, this.updateCreate != null);
        Boolean theConditionalCreate = this.getConditionalCreate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"conditionalCreate", (Object)theConditionalCreate), currentHashCode, (Object)theConditionalCreate, this.conditionalCreate != null);
        Boolean theConditionalUpdate = this.getConditionalUpdate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"conditionalUpdate", (Object)theConditionalUpdate), currentHashCode, (Object)theConditionalUpdate, this.conditionalUpdate != null);
        ConditionalDeleteStatus theConditionalDelete = this.getConditionalDelete();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"conditionalDelete", (Object)theConditionalDelete), currentHashCode, (Object)theConditionalDelete, this.conditionalDelete != null);
        List<String> theSearchInclude = this.searchInclude != null && !this.searchInclude.isEmpty() ? this.getSearchInclude() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"searchInclude", theSearchInclude), currentHashCode, theSearchInclude, this.searchInclude != null && !this.searchInclude.isEmpty());
        List<String> theSearchRevInclude = this.searchRevInclude != null && !this.searchRevInclude.isEmpty() ? this.getSearchRevInclude() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"searchRevInclude", theSearchRevInclude), currentHashCode, theSearchRevInclude, this.searchRevInclude != null && !this.searchRevInclude.isEmpty());
        List<ConformanceSearchParam> theSearchParam = this.searchParam != null && !this.searchParam.isEmpty() ? this.getSearchParam() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"searchParam", theSearchParam), currentHashCode, theSearchParam, this.searchParam != null && !this.searchParam.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Code theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        Reference theProfile = this.getProfile();
        strategy.appendField(locator, (Object)this, "profile", buffer, (Object)theProfile, this.profile != null);
        List<ConformanceInteraction> theInteraction = this.interaction != null && !this.interaction.isEmpty() ? this.getInteraction() : null;
        strategy.appendField(locator, (Object)this, "interaction", buffer, theInteraction, this.interaction != null && !this.interaction.isEmpty());
        ResourceVersionPolicy theVersioning = this.getVersioning();
        strategy.appendField(locator, (Object)this, "versioning", buffer, (Object)theVersioning, this.versioning != null);
        Boolean theReadHistory = this.getReadHistory();
        strategy.appendField(locator, (Object)this, "readHistory", buffer, (Object)theReadHistory, this.readHistory != null);
        Boolean theUpdateCreate = this.getUpdateCreate();
        strategy.appendField(locator, (Object)this, "updateCreate", buffer, (Object)theUpdateCreate, this.updateCreate != null);
        Boolean theConditionalCreate = this.getConditionalCreate();
        strategy.appendField(locator, (Object)this, "conditionalCreate", buffer, (Object)theConditionalCreate, this.conditionalCreate != null);
        Boolean theConditionalUpdate = this.getConditionalUpdate();
        strategy.appendField(locator, (Object)this, "conditionalUpdate", buffer, (Object)theConditionalUpdate, this.conditionalUpdate != null);
        ConditionalDeleteStatus theConditionalDelete = this.getConditionalDelete();
        strategy.appendField(locator, (Object)this, "conditionalDelete", buffer, (Object)theConditionalDelete, this.conditionalDelete != null);
        List<String> theSearchInclude = this.searchInclude != null && !this.searchInclude.isEmpty() ? this.getSearchInclude() : null;
        strategy.appendField(locator, (Object)this, "searchInclude", buffer, theSearchInclude, this.searchInclude != null && !this.searchInclude.isEmpty());
        List<String> theSearchRevInclude = this.searchRevInclude != null && !this.searchRevInclude.isEmpty() ? this.getSearchRevInclude() : null;
        strategy.appendField(locator, (Object)this, "searchRevInclude", buffer, theSearchRevInclude, this.searchRevInclude != null && !this.searchRevInclude.isEmpty());
        List<ConformanceSearchParam> theSearchParam = this.searchParam != null && !this.searchParam.isEmpty() ? this.getSearchParam() : null;
        strategy.appendField(locator, (Object)this, "searchParam", buffer, theSearchParam, this.searchParam != null && !this.searchParam.isEmpty());
        return buffer;
    }
}

