/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EnrollmentRequest", propOrder={"identifier", "ruleset", "originalRuleset", "created", "target", "provider", "organization", "subject", "coverage", "relationship"})
public class EnrollmentRequest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Reference target;
    protected Reference provider;
    protected Reference organization;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected Reference coverage;
    @XmlElement(required=true)
    protected Coding relationship;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Reference getTarget() {
        return this.target;
    }

    public void setTarget(Reference value) {
        this.target = value;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public void setProvider(Reference value) {
        this.provider = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getCoverage() {
        return this.coverage;
    }

    public void setCoverage(Reference value) {
        this.coverage = value;
    }

    public Coding getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Coding value) {
        this.relationship = value;
    }

    public EnrollmentRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public EnrollmentRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public EnrollmentRequest withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public EnrollmentRequest withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public EnrollmentRequest withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public EnrollmentRequest withTarget(Reference value) {
        this.setTarget(value);
        return this;
    }

    public EnrollmentRequest withProvider(Reference value) {
        this.setProvider(value);
        return this;
    }

    public EnrollmentRequest withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public EnrollmentRequest withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public EnrollmentRequest withCoverage(Reference value) {
        this.setCoverage(value);
        return this;
    }

    public EnrollmentRequest withRelationship(Coding value) {
        this.setRelationship(value);
        return this;
    }

    @Override
    public EnrollmentRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public EnrollmentRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public EnrollmentRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public EnrollmentRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public EnrollmentRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EnrollmentRequest that = (EnrollmentRequest)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"ruleset", (Object)lhsRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"ruleset", (Object)rhsRuleset), (Object)lhsRuleset, (Object)rhsRuleset, this.ruleset != null, that.ruleset != null)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"originalRuleset", (Object)lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"originalRuleset", (Object)rhsOriginalRuleset), (Object)lhsOriginalRuleset, (Object)rhsOriginalRuleset, this.originalRuleset != null, that.originalRuleset != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Reference lhsTarget = this.getTarget();
        Reference rhsTarget = that.getTarget();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"target", (Object)lhsTarget), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"target", (Object)rhsTarget), (Object)lhsTarget, (Object)rhsTarget, this.target != null, that.target != null)) {
            return false;
        }
        Reference lhsProvider = this.getProvider();
        Reference rhsProvider = that.getProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"provider", (Object)lhsProvider), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"provider", (Object)rhsProvider), (Object)lhsProvider, (Object)rhsProvider, this.provider != null, that.provider != null)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization, this.organization != null, that.organization != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Reference lhsCoverage = this.getCoverage();
        Reference rhsCoverage = that.getCoverage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"coverage", (Object)lhsCoverage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"coverage", (Object)rhsCoverage), (Object)lhsCoverage, (Object)rhsCoverage, this.coverage != null, that.coverage != null)) {
            return false;
        }
        Coding lhsRelationship = this.getRelationship();
        Coding rhsRelationship = that.getRelationship();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"relationship", (Object)lhsRelationship), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"relationship", (Object)rhsRelationship), (Object)lhsRelationship, (Object)rhsRelationship, this.relationship != null, that.relationship != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"ruleset", (Object)theRuleset), currentHashCode, (Object)theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"originalRuleset", (Object)theOriginalRuleset), currentHashCode, (Object)theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"created", (Object)theCreated), currentHashCode, (Object)theCreated, this.created != null);
        Reference theTarget = this.getTarget();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"target", (Object)theTarget), currentHashCode, (Object)theTarget, this.target != null);
        Reference theProvider = this.getProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"provider", (Object)theProvider), currentHashCode, (Object)theProvider, this.provider != null);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization, this.organization != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject, this.subject != null);
        Reference theCoverage = this.getCoverage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"coverage", (Object)theCoverage), currentHashCode, (Object)theCoverage, this.coverage != null);
        Coding theRelationship = this.getRelationship();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"relationship", (Object)theRelationship), currentHashCode, (Object)theRelationship, this.relationship != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, (Object)theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, (Object)theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated, this.created != null);
        Reference theTarget = this.getTarget();
        strategy.appendField(locator, (Object)this, "target", buffer, (Object)theTarget, this.target != null);
        Reference theProvider = this.getProvider();
        strategy.appendField(locator, (Object)this, "provider", buffer, (Object)theProvider, this.provider != null);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization, this.organization != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject, this.subject != null);
        Reference theCoverage = this.getCoverage();
        strategy.appendField(locator, (Object)this, "coverage", buffer, (Object)theCoverage, this.coverage != null);
        Coding theRelationship = this.getRelationship();
        strategy.appendField(locator, (Object)this, "relationship", buffer, (Object)theRelationship, this.relationship != null);
        return buffer;
    }
}

