/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SimpleQuantity;
import org.hl7.fhir.SupplyDeliveryStatus;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SupplyDelivery", propOrder={"identifier", "status", "patient", "type", "quantity", "suppliedItem", "supplier", "whenPrepared", "time", "destination", "receiver"})
public class SupplyDelivery
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier identifier;
    protected SupplyDeliveryStatus status;
    protected Reference patient;
    protected CodeableConcept type;
    protected SimpleQuantity quantity;
    protected Reference suppliedItem;
    protected Reference supplier;
    protected Period whenPrepared;
    protected DateTime time;
    protected Reference destination;
    protected List<Reference> receiver;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public SupplyDeliveryStatus getStatus() {
        return this.status;
    }

    public void setStatus(SupplyDeliveryStatus value) {
        this.status = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public SimpleQuantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(SimpleQuantity value) {
        this.quantity = value;
    }

    public Reference getSuppliedItem() {
        return this.suppliedItem;
    }

    public void setSuppliedItem(Reference value) {
        this.suppliedItem = value;
    }

    public Reference getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Reference value) {
        this.supplier = value;
    }

    public Period getWhenPrepared() {
        return this.whenPrepared;
    }

    public void setWhenPrepared(Period value) {
        this.whenPrepared = value;
    }

    public DateTime getTime() {
        return this.time;
    }

    public void setTime(DateTime value) {
        this.time = value;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public void setDestination(Reference value) {
        this.destination = value;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public SupplyDelivery withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public SupplyDelivery withStatus(SupplyDeliveryStatus value) {
        this.setStatus(value);
        return this;
    }

    public SupplyDelivery withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public SupplyDelivery withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public SupplyDelivery withQuantity(SimpleQuantity value) {
        this.setQuantity(value);
        return this;
    }

    public SupplyDelivery withSuppliedItem(Reference value) {
        this.setSuppliedItem(value);
        return this;
    }

    public SupplyDelivery withSupplier(Reference value) {
        this.setSupplier(value);
        return this;
    }

    public SupplyDelivery withWhenPrepared(Period value) {
        this.setWhenPrepared(value);
        return this;
    }

    public SupplyDelivery withTime(DateTime value) {
        this.setTime(value);
        return this;
    }

    public SupplyDelivery withDestination(Reference value) {
        this.setDestination(value);
        return this;
    }

    public SupplyDelivery withReceiver(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReceiver().add(value);
            }
        }
        return this;
    }

    public SupplyDelivery withReceiver(Collection<Reference> values) {
        if (values != null) {
            this.getReceiver().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyDelivery withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public SupplyDelivery withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyDelivery withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyDelivery withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyDelivery withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyDelivery withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyDelivery withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyDelivery withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public SupplyDelivery withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public SupplyDelivery withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public SupplyDelivery withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        SupplyDelivery that = (SupplyDelivery)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        SupplyDeliveryStatus lhsStatus = this.getStatus();
        SupplyDeliveryStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        SimpleQuantity lhsQuantity = this.getQuantity();
        SimpleQuantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity, this.quantity != null, that.quantity != null)) {
            return false;
        }
        Reference lhsSuppliedItem = this.getSuppliedItem();
        Reference rhsSuppliedItem = that.getSuppliedItem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"suppliedItem", (Object)lhsSuppliedItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"suppliedItem", (Object)rhsSuppliedItem), (Object)lhsSuppliedItem, (Object)rhsSuppliedItem, this.suppliedItem != null, that.suppliedItem != null)) {
            return false;
        }
        Reference lhsSupplier = this.getSupplier();
        Reference rhsSupplier = that.getSupplier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supplier", (Object)lhsSupplier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supplier", (Object)rhsSupplier), (Object)lhsSupplier, (Object)rhsSupplier, this.supplier != null, that.supplier != null)) {
            return false;
        }
        Period lhsWhenPrepared = this.getWhenPrepared();
        Period rhsWhenPrepared = that.getWhenPrepared();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"whenPrepared", (Object)lhsWhenPrepared), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"whenPrepared", (Object)rhsWhenPrepared), (Object)lhsWhenPrepared, (Object)rhsWhenPrepared, this.whenPrepared != null, that.whenPrepared != null)) {
            return false;
        }
        DateTime lhsTime = this.getTime();
        DateTime rhsTime = that.getTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"time", (Object)lhsTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"time", (Object)rhsTime), (Object)lhsTime, (Object)rhsTime, this.time != null, that.time != null)) {
            return false;
        }
        Reference lhsDestination = this.getDestination();
        Reference rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"destination", (Object)lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"destination", (Object)rhsDestination), (Object)lhsDestination, (Object)rhsDestination, this.destination != null, that.destination != null)) {
            return false;
        }
        List<Reference> lhsReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        List<Reference> rhsReceiver = that.receiver != null && !that.receiver.isEmpty() ? that.getReceiver() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"receiver", lhsReceiver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"receiver", rhsReceiver), lhsReceiver, rhsReceiver, this.receiver != null && !this.receiver.isEmpty(), that.receiver != null && !that.receiver.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier, this.identifier != null);
        SupplyDeliveryStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        SimpleQuantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity, this.quantity != null);
        Reference theSuppliedItem = this.getSuppliedItem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"suppliedItem", (Object)theSuppliedItem), currentHashCode, (Object)theSuppliedItem, this.suppliedItem != null);
        Reference theSupplier = this.getSupplier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supplier", (Object)theSupplier), currentHashCode, (Object)theSupplier, this.supplier != null);
        Period theWhenPrepared = this.getWhenPrepared();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"whenPrepared", (Object)theWhenPrepared), currentHashCode, (Object)theWhenPrepared, this.whenPrepared != null);
        DateTime theTime = this.getTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"time", (Object)theTime), currentHashCode, (Object)theTime, this.time != null);
        Reference theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"destination", (Object)theDestination), currentHashCode, (Object)theDestination, this.destination != null);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"receiver", theReceiver), currentHashCode, theReceiver, this.receiver != null && !this.receiver.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier, this.identifier != null);
        SupplyDeliveryStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        SimpleQuantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity, this.quantity != null);
        Reference theSuppliedItem = this.getSuppliedItem();
        strategy.appendField(locator, (Object)this, "suppliedItem", buffer, (Object)theSuppliedItem, this.suppliedItem != null);
        Reference theSupplier = this.getSupplier();
        strategy.appendField(locator, (Object)this, "supplier", buffer, (Object)theSupplier, this.supplier != null);
        Period theWhenPrepared = this.getWhenPrepared();
        strategy.appendField(locator, (Object)this, "whenPrepared", buffer, (Object)theWhenPrepared, this.whenPrepared != null);
        DateTime theTime = this.getTime();
        strategy.appendField(locator, (Object)this, "time", buffer, (Object)theTime, this.time != null);
        Reference theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, (Object)theDestination, this.destination != null);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        strategy.appendField(locator, (Object)this, "receiver", buffer, theReceiver, this.receiver != null && !this.receiver.isEmpty());
        return buffer;
    }
}

