/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.quick;

import java.io.IOException;
import org.cqframework.cql.cql2elm.quick.QuickModelInfoProvider;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReaderFactory;

public class UsCoreModelInfoProvider
implements ModelInfoProvider {
    private NamespaceManager namespaceManager;

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    private boolean isUSCoreModelIdentifier(ModelIdentifier modelIdentifier) {
        if (this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            return modelIdentifier.getId().equals("USCore") && (modelIdentifier.getSystem() == null || modelIdentifier.getSystem().equals("http://hl7.org/fhir/us/core"));
        }
        return modelIdentifier.getId().equals("USCore");
    }

    public ModelInfo load(ModelIdentifier modelIdentifier) {
        if (this.isUSCoreModelIdentifier(modelIdentifier)) {
            String localVersion = modelIdentifier.getVersion() == null ? "" : modelIdentifier.getVersion();
            try {
                switch (localVersion) {
                    case "3.1.0": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(QuickModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/uscore-modelinfo-3.1.0.xml"));
                    }
                }
                return ModelInfoReaderFactory.getReader((String)"application/xml").read(QuickModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/uscore-modelinfo-3.1.1.xml"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

