/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DocumentReferenceContent;
import org.hl7.fhir.DocumentReferenceContext;
import org.hl7.fhir.DocumentReferenceRelatesTo;
import org.hl7.fhir.DocumentReferenceStatus;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentReference", propOrder={"masterIdentifier", "identifier", "subject", "type", "clazz", "author", "custodian", "authenticator", "created", "indexed", "status", "docStatus", "relatesTo", "description", "securityLabel", "content", "context"})
public class DocumentReference
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier masterIdentifier;
    protected List<Identifier> identifier;
    protected Reference subject;
    @XmlElement(required=true)
    protected CodeableConcept type;
    @XmlElement(name="class")
    protected CodeableConcept clazz;
    protected List<Reference> author;
    protected Reference custodian;
    protected Reference authenticator;
    protected DateTime created;
    @XmlElement(required=true)
    protected Instant indexed;
    @XmlElement(required=true)
    protected DocumentReferenceStatus status;
    protected CodeableConcept docStatus;
    protected List<DocumentReferenceRelatesTo> relatesTo;
    protected String description;
    protected List<CodeableConcept> securityLabel;
    @XmlElement(required=true)
    protected List<DocumentReferenceContent> content;
    protected DocumentReferenceContext context;

    public Identifier getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public void setMasterIdentifier(Identifier value) {
        this.masterIdentifier = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public CodeableConcept getClazz() {
        return this.clazz;
    }

    public void setClazz(CodeableConcept value) {
        this.clazz = value;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public Reference getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Reference value) {
        this.custodian = value;
    }

    public Reference getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Reference value) {
        this.authenticator = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Instant getIndexed() {
        return this.indexed;
    }

    public void setIndexed(Instant value) {
        this.indexed = value;
    }

    public DocumentReferenceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DocumentReferenceStatus value) {
        this.status = value;
    }

    public CodeableConcept getDocStatus() {
        return this.docStatus;
    }

    public void setDocStatus(CodeableConcept value) {
        this.docStatus = value;
    }

    public List<DocumentReferenceRelatesTo> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<DocumentReferenceRelatesTo>();
        }
        return this.relatesTo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getSecurityLabel() {
        if (this.securityLabel == null) {
            this.securityLabel = new ArrayList<CodeableConcept>();
        }
        return this.securityLabel;
    }

    public List<DocumentReferenceContent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<DocumentReferenceContent>();
        }
        return this.content;
    }

    public DocumentReferenceContext getContext() {
        return this.context;
    }

    public void setContext(DocumentReferenceContext value) {
        this.context = value;
    }

    public DocumentReference withMasterIdentifier(Identifier value) {
        this.setMasterIdentifier(value);
        return this;
    }

    public DocumentReference withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public DocumentReference withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public DocumentReference withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public DocumentReference withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public DocumentReference withClazz(CodeableConcept value) {
        this.setClazz(value);
        return this;
    }

    public DocumentReference withAuthor(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthor().add(value);
            }
        }
        return this;
    }

    public DocumentReference withAuthor(Collection<Reference> values) {
        if (values != null) {
            this.getAuthor().addAll(values);
        }
        return this;
    }

    public DocumentReference withCustodian(Reference value) {
        this.setCustodian(value);
        return this;
    }

    public DocumentReference withAuthenticator(Reference value) {
        this.setAuthenticator(value);
        return this;
    }

    public DocumentReference withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public DocumentReference withIndexed(Instant value) {
        this.setIndexed(value);
        return this;
    }

    public DocumentReference withStatus(DocumentReferenceStatus value) {
        this.setStatus(value);
        return this;
    }

    public DocumentReference withDocStatus(CodeableConcept value) {
        this.setDocStatus(value);
        return this;
    }

    public DocumentReference withRelatesTo(DocumentReferenceRelatesTo ... values) {
        if (values != null) {
            for (DocumentReferenceRelatesTo value : values) {
                this.getRelatesTo().add(value);
            }
        }
        return this;
    }

    public DocumentReference withRelatesTo(Collection<DocumentReferenceRelatesTo> values) {
        if (values != null) {
            this.getRelatesTo().addAll(values);
        }
        return this;
    }

    public DocumentReference withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public DocumentReference withSecurityLabel(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSecurityLabel().add(value);
            }
        }
        return this;
    }

    public DocumentReference withSecurityLabel(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSecurityLabel().addAll(values);
        }
        return this;
    }

    public DocumentReference withContent(DocumentReferenceContent ... values) {
        if (values != null) {
            for (DocumentReferenceContent value : values) {
                this.getContent().add(value);
            }
        }
        return this;
    }

    public DocumentReference withContent(Collection<DocumentReferenceContent> values) {
        if (values != null) {
            this.getContent().addAll(values);
        }
        return this;
    }

    public DocumentReference withContext(DocumentReferenceContext value) {
        this.setContext(value);
        return this;
    }

    @Override
    public DocumentReference withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DocumentReference withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReference withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReference withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReference withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReference withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReference withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReference withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DocumentReference withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DocumentReference withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DocumentReference withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DocumentReference that = (DocumentReference)object;
        Identifier lhsMasterIdentifier = this.getMasterIdentifier();
        Identifier rhsMasterIdentifier = that.getMasterIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"masterIdentifier", (Object)lhsMasterIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"masterIdentifier", (Object)rhsMasterIdentifier), (Object)lhsMasterIdentifier, (Object)rhsMasterIdentifier, this.masterIdentifier != null, that.masterIdentifier != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        CodeableConcept lhsClazz = this.getClazz();
        CodeableConcept rhsClazz = that.getClazz();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"clazz", (Object)lhsClazz), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"clazz", (Object)rhsClazz), (Object)lhsClazz, (Object)rhsClazz, this.clazz != null, that.clazz != null)) {
            return false;
        }
        List<Reference> lhsAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        List<Reference> rhsAuthor = that.author != null && !that.author.isEmpty() ? that.getAuthor() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"author", lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"author", rhsAuthor), lhsAuthor, rhsAuthor, this.author != null && !this.author.isEmpty(), that.author != null && !that.author.isEmpty())) {
            return false;
        }
        Reference lhsCustodian = this.getCustodian();
        Reference rhsCustodian = that.getCustodian();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"custodian", (Object)lhsCustodian), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"custodian", (Object)rhsCustodian), (Object)lhsCustodian, (Object)rhsCustodian, this.custodian != null, that.custodian != null)) {
            return false;
        }
        Reference lhsAuthenticator = this.getAuthenticator();
        Reference rhsAuthenticator = that.getAuthenticator();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"authenticator", (Object)lhsAuthenticator), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"authenticator", (Object)rhsAuthenticator), (Object)lhsAuthenticator, (Object)rhsAuthenticator, this.authenticator != null, that.authenticator != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Instant lhsIndexed = this.getIndexed();
        Instant rhsIndexed = that.getIndexed();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"indexed", (Object)lhsIndexed), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"indexed", (Object)rhsIndexed), (Object)lhsIndexed, (Object)rhsIndexed, this.indexed != null, that.indexed != null)) {
            return false;
        }
        DocumentReferenceStatus lhsStatus = this.getStatus();
        DocumentReferenceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsDocStatus = this.getDocStatus();
        CodeableConcept rhsDocStatus = that.getDocStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"docStatus", (Object)lhsDocStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"docStatus", (Object)rhsDocStatus), (Object)lhsDocStatus, (Object)rhsDocStatus, this.docStatus != null, that.docStatus != null)) {
            return false;
        }
        List<DocumentReferenceRelatesTo> lhsRelatesTo = this.relatesTo != null && !this.relatesTo.isEmpty() ? this.getRelatesTo() : null;
        List<DocumentReferenceRelatesTo> rhsRelatesTo = that.relatesTo != null && !that.relatesTo.isEmpty() ? that.getRelatesTo() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"relatesTo", lhsRelatesTo), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"relatesTo", rhsRelatesTo), lhsRelatesTo, rhsRelatesTo, this.relatesTo != null && !this.relatesTo.isEmpty(), that.relatesTo != null && !that.relatesTo.isEmpty())) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsSecurityLabel = this.securityLabel != null && !this.securityLabel.isEmpty() ? this.getSecurityLabel() : null;
        List<CodeableConcept> rhsSecurityLabel = that.securityLabel != null && !that.securityLabel.isEmpty() ? that.getSecurityLabel() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"securityLabel", lhsSecurityLabel), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"securityLabel", rhsSecurityLabel), lhsSecurityLabel, rhsSecurityLabel, this.securityLabel != null && !this.securityLabel.isEmpty(), that.securityLabel != null && !that.securityLabel.isEmpty())) {
            return false;
        }
        List<DocumentReferenceContent> lhsContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        List<DocumentReferenceContent> rhsContent = that.content != null && !that.content.isEmpty() ? that.getContent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"content", lhsContent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"content", rhsContent), lhsContent, rhsContent, this.content != null && !this.content.isEmpty(), that.content != null && !that.content.isEmpty())) {
            return false;
        }
        DocumentReferenceContext lhsContext = this.getContext();
        DocumentReferenceContext rhsContext = that.getContext();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"context", (Object)lhsContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"context", (Object)rhsContext), (Object)lhsContext, (Object)rhsContext, this.context != null, that.context != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theMasterIdentifier = this.getMasterIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"masterIdentifier", (Object)theMasterIdentifier), currentHashCode, (Object)theMasterIdentifier, this.masterIdentifier != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject, this.subject != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        CodeableConcept theClazz = this.getClazz();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"clazz", (Object)theClazz), currentHashCode, (Object)theClazz, this.clazz != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"author", theAuthor), currentHashCode, theAuthor, this.author != null && !this.author.isEmpty());
        Reference theCustodian = this.getCustodian();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"custodian", (Object)theCustodian), currentHashCode, (Object)theCustodian, this.custodian != null);
        Reference theAuthenticator = this.getAuthenticator();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"authenticator", (Object)theAuthenticator), currentHashCode, (Object)theAuthenticator, this.authenticator != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated, this.created != null);
        Instant theIndexed = this.getIndexed();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"indexed", (Object)theIndexed), currentHashCode, (Object)theIndexed, this.indexed != null);
        DocumentReferenceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        CodeableConcept theDocStatus = this.getDocStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"docStatus", (Object)theDocStatus), currentHashCode, (Object)theDocStatus, this.docStatus != null);
        List<DocumentReferenceRelatesTo> theRelatesTo = this.relatesTo != null && !this.relatesTo.isEmpty() ? this.getRelatesTo() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"relatesTo", theRelatesTo), currentHashCode, theRelatesTo, this.relatesTo != null && !this.relatesTo.isEmpty());
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        List<CodeableConcept> theSecurityLabel = this.securityLabel != null && !this.securityLabel.isEmpty() ? this.getSecurityLabel() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"securityLabel", theSecurityLabel), currentHashCode, theSecurityLabel, this.securityLabel != null && !this.securityLabel.isEmpty());
        List<DocumentReferenceContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"content", theContent), currentHashCode, theContent, this.content != null && !this.content.isEmpty());
        DocumentReferenceContext theContext = this.getContext();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"context", (Object)theContext), currentHashCode, (Object)theContext, this.context != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theMasterIdentifier = this.getMasterIdentifier();
        strategy.appendField(locator, (Object)this, "masterIdentifier", buffer, (Object)theMasterIdentifier, this.masterIdentifier != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject, this.subject != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        CodeableConcept theClazz = this.getClazz();
        strategy.appendField(locator, (Object)this, "clazz", buffer, (Object)theClazz, this.clazz != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        strategy.appendField(locator, (Object)this, "author", buffer, theAuthor, this.author != null && !this.author.isEmpty());
        Reference theCustodian = this.getCustodian();
        strategy.appendField(locator, (Object)this, "custodian", buffer, (Object)theCustodian, this.custodian != null);
        Reference theAuthenticator = this.getAuthenticator();
        strategy.appendField(locator, (Object)this, "authenticator", buffer, (Object)theAuthenticator, this.authenticator != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated, this.created != null);
        Instant theIndexed = this.getIndexed();
        strategy.appendField(locator, (Object)this, "indexed", buffer, (Object)theIndexed, this.indexed != null);
        DocumentReferenceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        CodeableConcept theDocStatus = this.getDocStatus();
        strategy.appendField(locator, (Object)this, "docStatus", buffer, (Object)theDocStatus, this.docStatus != null);
        List<DocumentReferenceRelatesTo> theRelatesTo = this.relatesTo != null && !this.relatesTo.isEmpty() ? this.getRelatesTo() : null;
        strategy.appendField(locator, (Object)this, "relatesTo", buffer, theRelatesTo, this.relatesTo != null && !this.relatesTo.isEmpty());
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        List<CodeableConcept> theSecurityLabel = this.securityLabel != null && !this.securityLabel.isEmpty() ? this.getSecurityLabel() : null;
        strategy.appendField(locator, (Object)this, "securityLabel", buffer, theSecurityLabel, this.securityLabel != null && !this.securityLabel.isEmpty());
        List<DocumentReferenceContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        strategy.appendField(locator, (Object)this, "content", buffer, theContent, this.content != null && !this.content.isEmpty());
        DocumentReferenceContext theContext = this.getContext();
        strategy.appendField(locator, (Object)this, "context", buffer, (Object)theContext, this.context != null);
        return buffer;
    }

    public void setIdentifier(List<Identifier> value) {
        this.identifier = value;
    }

    public void setAuthor(List<Reference> value) {
        this.author = value;
    }

    public void setRelatesTo(List<DocumentReferenceRelatesTo> value) {
        this.relatesTo = value;
    }

    public void setSecurityLabel(List<CodeableConcept> value) {
        this.securityLabel = value;
    }

    public void setContent(List<DocumentReferenceContent> value) {
        this.content = value;
    }
}

