/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.converters.ErrorWriter;
import cucumber.deps.com.thoughtworks.xstream.io.AbstractReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListOfComplexTypeReader
extends AbstractReader {
    private final Class elementType;
    private final List<String> attributeNames;
    private final Iterator<List<String>> itemIterator;
    private int depth = 0;
    private Iterator<String> attributeNameIterator;
    private String attributeName;
    private Iterator<String> attributeValueIterator;
    private String attributeValue;

    public ListOfComplexTypeReader(Class elementType, List<String> attributeNames, List<List<String>> items) {
        this.elementType = elementType;
        this.attributeNames = attributeNames;
        this.itemIterator = items.iterator();
    }

    @Override
    public boolean hasMoreChildren() {
        switch (this.depth) {
            case 0: {
                return this.itemIterator.hasNext();
            }
            case 1: {
                return this.attributeNameIterator.hasNext();
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    @Override
    public void moveDown() {
        ++this.depth;
        switch (this.depth) {
            case 1: {
                this.attributeNameIterator = this.attributeNames.iterator();
                this.attributeValueIterator = this.itemIterator.next().iterator();
                break;
            }
            case 2: {
                this.attributeName = this.attributeNameIterator.next();
                this.attributeValue = this.attributeValueIterator.next();
                break;
            }
            default: {
                throw new IllegalStateException("Depth is " + this.depth);
            }
        }
    }

    @Override
    public void moveUp() {
        --this.depth;
    }

    @Override
    public String getNodeName() {
        switch (this.depth) {
            case 0: {
                return "list";
            }
            case 1: {
                return this.elementType.getName();
            }
            case 2: {
                return this.attributeName;
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    @Override
    public String getValue() {
        return this.attributeValue;
    }

    @Override
    public String getAttribute(String name) {
        return null;
    }

    @Override
    public String getAttribute(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAttributeCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getAttributeNames() {
        return Collections.emptyList().iterator();
    }

    @Override
    public void appendErrors(ErrorWriter errorWriter) {
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

