/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Mappable
implements Serializable {
    private static final Integer NO_LINE = -1;

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Field> mappableFields = this.getMappableFields();
        for (Field field : mappableFields) {
            Map<String, Object> value = this.getValue(field);
            if (value != null && Mappable.class.isAssignableFrom(value.getClass())) {
                value = ((Mappable)((Object)value)).toMap();
            }
            if (value != null && Collection.class.isAssignableFrom(value.getClass())) {
                ArrayList<Map<String, Object>> mappedValue = new ArrayList<Map<String, Object>>();
                for (Object o : (Collection)((Object)value)) {
                    if (Mappable.class.isAssignableFrom(o.getClass())) {
                        mappedValue.add(((Mappable)o).toMap());
                        continue;
                    }
                    mappedValue.add((Map<String, Object>)o);
                }
                value = mappedValue;
            }
            if (value == null || Collections.EMPTY_LIST.equals(value) || NO_LINE.equals(value)) continue;
            map.put(field.getName(), value);
        }
        return map;
    }

    private Object getValue(Field field) {
        try {
            field.setAccessible(true);
            return field.get(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Field> getMappableFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!this.isMappable(field)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    private boolean isMappable(Field field) {
        boolean transientField = Modifier.isTransient(field.getModifiers());
        boolean instanceField = !Modifier.isStatic(field.getModifiers());
        boolean mappableType = this.isMappableType(field.getType(), field.getGenericType());
        return !transientField && instanceField && mappableType;
    }

    private boolean isMappableType(Class type, Type genericType) {
        return String.class.equals((Object)type) || type.isPrimitive() || Number.class.isAssignableFrom(type) || Mappable.class.isAssignableFrom(type) || genericType != null && Collection.class.isAssignableFrom(type) && this.isMappableCollection(genericType);
    }

    private boolean isMappableCollection(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            Type[] parameters = ((ParameterizedType)genericType).getActualTypeArguments();
            return parameters[0] instanceof Class && this.isMappableType((Class)parameters[0], null);
        }
        return false;
    }
}

