/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class Env {
    private final String bundleName;
    private final Properties properties;

    public Env() {
        this(null, System.getProperties());
    }

    public Env(String bundleName) {
        this(bundleName, System.getProperties());
    }

    public Env(Properties properties) {
        this(null, properties);
    }

    public Env(String bundleName, Properties properties) {
        this.bundleName = bundleName;
        this.properties = properties;
    }

    public String get(String key) {
        String result = this.getFromEnvironment(key);
        if (result == null && (result = this.getFromProperty(key)) == null && this.bundleName != null) {
            result = this.getFromBundle(key);
        }
        return result;
    }

    private String getFromEnvironment(String key) {
        String value = System.getenv(Env.asEnvKey(key));
        if (value == null) {
            value = System.getenv(Env.asPropertyKey(key));
        }
        return value;
    }

    private String getFromProperty(String key) {
        String value = this.properties.getProperty(Env.asEnvKey(key));
        if (value == null) {
            value = this.properties.getProperty(Env.asPropertyKey(key));
        }
        return value;
    }

    private String getFromBundle(String key) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.bundleName);
            try {
                return bundle.getString(Env.asEnvKey(key));
            }
            catch (MissingResourceException stringNotFound) {
                try {
                    return bundle.getString(Env.asPropertyKey(key));
                }
                catch (MissingResourceException ignoreStringNotFound) {
                    return bundle.getString(Env.asPropertyKey(key));
                }
            }
        }
        catch (MissingResourceException ignoreBundleNotFound) {
            return null;
        }
    }

    public String get(String key, String defaultValue) {
        String result = this.get(key);
        return result != null ? result : defaultValue;
    }

    private static String asEnvKey(String key) {
        return key.replace('.', '_').toUpperCase();
    }

    private static String asPropertyKey(String key) {
        return key.replace('_', '.').toLowerCase();
    }
}

