/*
 * Decompiled with CFR 0.152.
 */
package cucumber.formatter;

import cucumber.runtime.CucumberException;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.formatter.Formatter;
import gherkin.formatter.Mappable;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTMLFormatter
implements Formatter,
Reporter {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String JS_FORMATTER_VAR = "formatter";
    private static final String JS_REPORT_FILENAME = "report.js";
    private static final String[] TEXT_ASSETS = new String[]{"formatter.js", "index.html", "jquery-1.6.4.min.js", "style.css"};
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
        }
    };
    private final File htmlReportDir;
    private NiceAppendable jsOut;
    private boolean firstFeature = true;
    private int embeddedIndex;

    public HTMLFormatter(File htmlReportDir) {
        this.htmlReportDir = htmlReportDir;
    }

    @Override
    public void uri(String uri) {
        if (this.firstFeature) {
            this.jsOut().append("$(document).ready(function() {").append("var ").append(JS_FORMATTER_VAR).append(" = new CucumberHTML.DOMFormatter($('.cucumber-report'));");
            this.firstFeature = false;
        }
        this.writeToJsReport("uri", "'" + uri + "'");
    }

    @Override
    public void feature(Feature feature) {
        this.writeToJsReport("feature", feature);
    }

    @Override
    public void background(Background background) {
        this.writeToJsReport("background", background);
    }

    @Override
    public void scenario(Scenario scenario) {
        this.writeToJsReport("scenario", scenario);
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.writeToJsReport("scenarioOutline", scenarioOutline);
    }

    @Override
    public void examples(Examples examples) {
        this.writeToJsReport("examples", examples);
    }

    @Override
    public void step(Step step) {
        this.writeToJsReport("step", step);
    }

    @Override
    public void eof() {
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    @Override
    public void done() {
        if (!this.firstFeature) {
            this.jsOut().append("});");
            this.copyReportFiles();
        }
    }

    @Override
    public void close() {
        this.jsOut().close();
    }

    private void writeToJsReport(String functionName, Mappable statement) {
        String json = gson.toJson(statement.toMap());
        this.writeToJsReport(functionName, json);
    }

    private void writeToJsReport(String functionName, String arg) {
        this.jsOut().append("formatter.").append(functionName).append("(").append(arg).append(");").println();
    }

    @Override
    public void result(Result result) {
        this.writeToJsReport("result", result);
    }

    @Override
    public void before(Match match, Result result) {
        this.writeToJsReport("before", result);
    }

    @Override
    public void after(Match match, Result result) {
        this.writeToJsReport("after", result);
    }

    @Override
    public void match(Match match) {
        this.writeToJsReport("match", match);
    }

    @Override
    public void embedding(String mimeType, byte[] data) {
        String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
        if (extension != null) {
            StringBuilder fileName = new StringBuilder("embedded").append(this.embeddedIndex++).append(".").append(extension);
            this.writeBytesAndClose(data, this.reportFileOutputStream(fileName.toString()));
            this.writeToJsReport("embedding", "'" + mimeType + "','" + fileName + "'");
        }
    }

    @Override
    public void write(String text) {
        this.writeToJsReport("write", gson.toJson(text));
    }

    private void copyReportFiles() {
        for (String textAsset : TEXT_ASSETS) {
            InputStream textAssetStream = this.getClass().getResourceAsStream(textAsset);
            this.writeStreamAndClose(textAssetStream, this.reportFileOutputStream(textAsset));
        }
    }

    private void writeStreamAndClose(InputStream in, OutputStream out) {
        byte[] buffer = new byte[16384];
        try {
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
            out.close();
        }
        catch (IOException e) {
            throw new CucumberException("Unable to write to report file item: ", e);
        }
    }

    private void writeBytesAndClose(byte[] buf, OutputStream out) {
        try {
            out.write(buf);
        }
        catch (IOException e) {
            throw new CucumberException("Unable to write to report file item: ", e);
        }
    }

    private NiceAppendable jsOut() {
        if (this.jsOut == null) {
            try {
                this.jsOut = new NiceAppendable(new OutputStreamWriter(this.reportFileOutputStream(JS_REPORT_FILENAME), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new CucumberException(e);
            }
        }
        return this.jsOut;
    }

    private OutputStream reportFileOutputStream(String fileName) {
        this.htmlReportDir.mkdirs();
        File file = new File(this.htmlReportDir, fileName);
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CucumberException("Error creating file: " + file.getAbsolutePath(), e);
        }
    }
}

