/*
 * Decompiled with CFR 0.152.
 */
package cucumber.formatter;

import cucumber.runtime.CucumberException;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitFormatter
implements Formatter,
Reporter {
    private final File out;
    private final Document doc;
    private final Element rootElement;
    private TestCase testCase;

    public JUnitFormatter(File out) {
        this.out = out;
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.rootElement = this.doc.createElement("testsuite");
            this.doc.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error while processing unit report", e);
        }
    }

    @Override
    public void feature(Feature feature) {
        TestCase.feature = feature;
    }

    @Override
    public void background(Background background) {
        this.testCase = new TestCase();
    }

    @Override
    public void scenario(Scenario scenario) {
        if (this.testCase != null) {
            this.testCase.scenario = scenario;
        } else {
            this.testCase = new TestCase(scenario);
        }
        this.increaseAttributeValue(this.rootElement, "tests");
    }

    @Override
    public void step(Step step) {
        if (this.testCase != null) {
            this.testCase.steps.add(step);
        }
    }

    @Override
    public void done() {
        try {
            this.rootElement.setAttribute("failures", String.valueOf(this.rootElement.getElementsByTagName("failure").getLength()));
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(this.out);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            new CucumberException("Error while transforming.", e);
        }
    }

    @Override
    public void result(Result result) {
        this.testCase.results.add(result);
        if (this.testCase.scenario != null && this.testCase.results.size() == this.testCase.steps.size()) {
            this.rootElement.appendChild(this.testCase.writeTo(this.doc));
            this.testCase = null;
        }
    }

    @Override
    public void before(Match match, Result result) {
        this.handleHook(result);
    }

    @Override
    public void after(Match match, Result result) {
        this.handleHook(result);
    }

    private void handleHook(Result result) {
        if (result.getStatus().equals("failed")) {
            this.testCase.results.add(result);
        }
    }

    private void increaseAttributeValue(Element element, String attribute) {
        int value = 0;
        if (element.hasAttribute(attribute)) {
            value = Integer.parseInt(element.getAttribute(attribute));
        }
        element.setAttribute(attribute, String.valueOf(++value));
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    @Override
    public void examples(Examples examples) {
        TestCase.examples = examples.getRows().size() - 1;
    }

    @Override
    public void match(Match match) {
    }

    @Override
    public void embedding(String mimeType, byte[] data) {
    }

    @Override
    public void write(String text) {
    }

    @Override
    public void uri(String uri) {
    }

    @Override
    public void close() {
    }

    @Override
    public void eof() {
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    private static class TestCase {
        private static final DecimalFormat NUMBER_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        Scenario scenario;
        static Feature feature;
        static int examples;
        final List<Step> steps = new ArrayList<Step>();
        final List<Result> results = new ArrayList<Result>();

        private TestCase(Scenario scenario) {
            this.scenario = scenario;
        }

        private TestCase() {
        }

        private Element writeTo(Document doc) {
            Element child;
            Element tc = doc.createElement("testcase");
            tc.setAttribute("classname", feature.getName());
            tc.setAttribute("name", examples > 0 ? this.scenario.getName() + "_" + examples-- : this.scenario.getName());
            long totalDurationNanos = 0L;
            for (Result r : this.results) {
                totalDurationNanos += r.getDuration() == null ? 0L : r.getDuration();
            }
            double totalDurationSeconds = (double)totalDurationNanos / 1.0E9;
            String time = NUMBER_FORMAT.format(totalDurationSeconds);
            tc.setAttribute("time", time);
            StringBuilder sb = new StringBuilder();
            Result skipped = null;
            Result failed = null;
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                Result result = this.results.get(i);
                if ("failed".equals(result.getStatus())) {
                    failed = result;
                }
                if ("undefined".equals(result.getStatus()) || "pending".equals(result.getStatus())) {
                    skipped = result;
                }
                sb.append(this.steps.get(i).getKeyword());
                sb.append(this.steps.get(i).getName());
                int j = 0;
                while (sb.length() - length + j < 140) {
                    sb.append(".");
                    ++j;
                }
                sb.append(result.getStatus());
                sb.append("\n");
            }
            if (failed != null) {
                sb.append("\nStackTrace:\n");
                StringWriter sw = new StringWriter();
                failed.getError().printStackTrace(new PrintWriter(sw));
                sb.append(sw.toString());
                child = doc.createElement("failure");
                child.setAttribute("message", failed.getErrorMessage());
                child.appendChild(doc.createCDATASection(sb.toString()));
            } else if (skipped != null) {
                child = doc.createElement("skipped");
                child.appendChild(doc.createCDATASection(sb.toString()));
            } else {
                child = doc.createElement("system-out");
                child.appendChild(doc.createCDATASection(sb.toString()));
            }
            tc.appendChild(child);
            return tc;
        }

        static {
            NUMBER_FORMAT.applyPattern("0.######");
            examples = 0;
        }
    }
}

