/*
 * Decompiled with CFR 0.152.
 */
package cucumber.io;

import cucumber.io.ClasspathIterable;
import cucumber.io.Resource;
import cucumber.io.ZipResource;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipResourceIterator
implements Iterator<Resource> {
    private final String path;
    private final String suffix;
    private final ZipFile jarFile;
    private final Enumeration<? extends ZipEntry> entries;
    private Resource next;

    public ZipResourceIterator(String zipPath, String path, String suffix) throws IOException {
        this.path = path;
        this.suffix = suffix;
        this.jarFile = new ZipFile(zipPath);
        this.entries = this.jarFile.entries();
        this.moveToNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource next() {
        try {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Resource resource = this.next;
            return resource;
        }
        finally {
            this.moveToNext();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void moveToNext() {
        this.next = null;
        while (this.entries.hasMoreElements()) {
            ZipEntry jarEntry = this.entries.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.startsWith(this.path) || !ClasspathIterable.hasSuffix(this.suffix, entryName)) continue;
            this.next = new ZipResource(this.jarFile, jarEntry);
            break;
        }
    }
}

