/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.DateFormat;
import cucumber.Delimiter;
import cucumber.api.Transform;
import cucumber.deps.com.thoughtworks.xstream.annotations.XStreamConverter;
import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.converters.EnumConverter;
import cucumber.runtime.converters.ListConverter;
import cucumber.runtime.converters.LocalizedXStreams;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ParameterType {
    public static final String DEFAULT_DELIMITER = ", ?";
    private final Type type;
    private final String dateFormat;
    private final String delimiter;
    private final SingleValueConverter singleValueConverter;

    public static List<ParameterType> fromMethod(Method method) {
        ArrayList<ParameterType> result = new ArrayList<ParameterType>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            String dateFormat = null;
            String delimiter = DEFAULT_DELIMITER;
            SingleValueConverter singleValueConverter = null;
            for (Annotation annotation : annotations[i]) {
                if (annotation instanceof DateFormat) {
                    dateFormat = ((DateFormat)annotation).value();
                }
                if (annotation instanceof Delimiter) {
                    delimiter = ((Delimiter)annotation).value();
                }
                if (!(annotation instanceof Transform)) continue;
                try {
                    singleValueConverter = ((Transform)annotation).value().newInstance();
                }
                catch (InstantiationException e) {
                    throw new CucumberException(e);
                }
                catch (IllegalAccessException e) {
                    throw new CucumberException(e);
                }
            }
            result.add(new ParameterType(genericParameterTypes[i], dateFormat, delimiter, singleValueConverter));
        }
        return result;
    }

    public ParameterType(Type type, String dateFormat, String delimiter, SingleValueConverter singleValueConverter) {
        this.type = type;
        this.dateFormat = dateFormat;
        this.delimiter = delimiter;
        this.singleValueConverter = singleValueConverter;
    }

    public Class<?> getRawType() {
        return this.getRawType(this.type);
    }

    private Class<?> getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(String value, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        try {
            SingleValueConverter converter;
            xStream.setDateFormat(this.dateFormat);
            xStream.processAnnotations(this.getRawType());
            if (this.singleValueConverter != null) {
                converter = this.singleValueConverter;
            } else {
                converter = List.class.isAssignableFrom(this.getRawType()) ? this.getListConverter(this.type, xStream, locale) : this.getConverter(this.getRawType(), xStream, locale);
                if (converter == null) {
                    throw new CucumberException(String.format("Don't know how to convert \"%s\" into %s.\nTry writing your own converter:\n\n@%s(%sConverter.class)\npublic class %s {}\n", value, this.getRawType().getName(), XStreamConverter.class.getName(), this.getRawType().getSimpleName(), this.getRawType().getSimpleName()));
                }
            }
            Object object = converter.fromString(value);
            return object;
        }
        finally {
            xStream.unsetDateFormat();
        }
    }

    private SingleValueConverter getListConverter(Type type, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        Class<Object> elementType = type instanceof ParameterizedType ? this.getRawType(((ParameterizedType)type).getActualTypeArguments()[0]) : Object.class;
        SingleValueConverter elementConverter = this.getConverter(elementType, xStream, locale);
        if (elementConverter == null) {
            return null;
        }
        return new ListConverter(this.delimiter, elementConverter);
    }

    private SingleValueConverter getConverter(Class<?> type, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        if (type.isEnum()) {
            return new EnumConverter(locale, type);
        }
        return xStream.getSingleValueConverter(type);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }
}

