/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.converters;

import cucumber.deps.com.thoughtworks.xstream.converters.ConversionException;
import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import cucumber.runtime.CucumberException;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.List;

abstract class ConverterWithFormat<T>
implements SingleValueConverter {
    private final Class[] convertibleTypes;

    ConverterWithFormat(Class[] convertibleTypes) {
        this.convertibleTypes = convertibleTypes;
    }

    public T fromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (Format format : this.getFormats()) {
            try {
                return (T)this.transform(format, string);
            }
            catch (Exception ignore) {
            }
        }
        throw new ConversionException("Couldn't convert \"" + string + "\" to an instance of: " + Arrays.asList(this.convertibleTypes));
    }

    protected abstract List<? extends Format> getFormats();

    Object transform(Format format, String argument) {
        ParsePosition position = new ParsePosition(0);
        Object result = format.parseObject(argument, position);
        if (position.getErrorIndex() != -1) {
            throw new CucumberException("Can't parse '" + argument + "' using format " + format);
        }
        return result;
    }

    @Override
    public String toString(Object obj) {
        return this.getFormats().get(0).format(obj);
    }

    @Override
    public boolean canConvert(Class type) {
        for (Class convertibleType : this.convertibleTypes) {
            if (!convertibleType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }
}

