/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.ScenarioResult;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ScenarioResultImpl
implements ScenarioResult {
    private static final List<String> SEVERITY = Arrays.asList("passed", "undefined", "pending", "skipped", "failed");
    private final List<Result> stepResults = new ArrayList<Result>();
    private final Reporter reporter;

    public ScenarioResultImpl(Reporter reporter) {
        this.reporter = reporter;
    }

    void add(Result result) {
        this.stepResults.add(result);
    }

    @Override
    public String getStatus() {
        int pos = 0;
        for (Result stepResult : this.stepResults) {
            pos = Math.max(pos, SEVERITY.indexOf(stepResult.getStatus()));
        }
        return SEVERITY.get(pos);
    }

    @Override
    public boolean isFailed() {
        return "failed".equals(this.getStatus());
    }

    @Override
    public void embed(byte[] data, String mimeType) {
        this.reporter.embedding(mimeType, data);
    }

    @Override
    public void write(String text) {
        this.reporter.write(text);
    }
}

