/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.runtime.HookDefinition;
import cucumber.runtime.ScenarioResult;
import cucumber.runtime.Timeout;
import cucumber.runtime.groovy.GroovyBackend;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import groovy.lang.Closure;
import java.util.Collection;

public class GroovyHookDefinition
implements HookDefinition {
    private final TagExpression tagExpression;
    private final int timeoutMillis;
    private final Closure body;
    private final GroovyBackend backend;
    private final StackTraceElement location;

    public GroovyHookDefinition(TagExpression tagExpression, int timeoutMillis, Closure body, StackTraceElement location, GroovyBackend backend) {
        this.tagExpression = tagExpression;
        this.timeoutMillis = timeoutMillis;
        this.body = body;
        this.location = location;
        this.backend = backend;
    }

    @Override
    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    @Override
    public void execute(final ScenarioResult scenarioResult) throws Throwable {
        Timeout.timeout(new Timeout.Callback<Object>(){

            @Override
            public Object call() throws Throwable {
                GroovyHookDefinition.this.backend.invoke(GroovyHookDefinition.this.body, new Object[]{scenarioResult});
                return null;
            }
        }, this.timeoutMillis);
    }

    @Override
    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.eval(tags);
    }

    @Override
    public int getOrder() {
        return this.location.getFileName() == "env.groovy" ? -1 : 0;
    }
}

