/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.StepContainer;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Tag;
import gherkin.formatter.model.TagStatement;
import gherkin.util.FixJava;
import java.util.HashSet;
import java.util.Set;

public abstract class CucumberTagStatement
extends StepContainer {
    final TagStatement tagStatement;
    private final String visualName;

    CucumberTagStatement(CucumberFeature cucumberFeature, TagStatement tagStatement) {
        super(cucumberFeature, tagStatement);
        this.tagStatement = tagStatement;
        this.visualName = tagStatement.getKeyword() + ": " + tagStatement.getName();
    }

    CucumberTagStatement(CucumberFeature cucumberFeature, TagStatement tagStatement, Row example) {
        super(cucumberFeature, tagStatement);
        this.tagStatement = tagStatement;
        this.visualName = "| " + FixJava.join(example.getCells(), " | ") + " |";
    }

    protected Set<Tag> tagsAndInheritedTags() {
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.addAll(this.cucumberFeature.getFeature().getTags());
        tags.addAll(this.tagStatement.getTags());
        return tags;
    }

    public String getVisualName() {
        return this.visualName;
    }

    public abstract void run(Formatter var1, Reporter var2, Runtime var3);
}

