/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table.xstream;

import cucumber.table.xstream.CellWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ComplexTypeWriter
extends CellWriter {
    private final List<String> columnNames;
    private final List<String> fieldNames = new ArrayList<String>();
    private final List<String> fieldValues = new ArrayList<String>();
    private int nodeDepth = 0;

    public ComplexTypeWriter(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public List<String> getHeader() {
        return this.columnNames.size() > 0 ? this.columnNames : this.fieldNames;
    }

    @Override
    public List<String> getValues() {
        if (this.columnNames.size() > 0) {
            String[] explicitFieldValues = new String[this.columnNames.size()];
            int n = 0;
            for (String columnName : this.columnNames) {
                int index = this.fieldNames.indexOf(columnName);
                explicitFieldValues[n] = index == -1 ? "" : this.fieldValues.get(index);
                ++n;
            }
            return Arrays.asList(explicitFieldValues);
        }
        return this.fieldValues;
    }

    @Override
    public void startNode(String name) {
        if (this.nodeDepth == 1) {
            this.fieldNames.add(name);
        }
        ++this.nodeDepth;
    }

    @Override
    public void addAttribute(String name, String value) {
    }

    @Override
    public void setValue(String value) {
        this.fieldValues.add(value == null ? "" : value);
    }

    @Override
    public void endNode() {
        --this.nodeDepth;
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

