/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.ParameterType;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.groovy.GroovyBackend;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import groovy.lang.Closure;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GroovyStepDefinition
implements StepDefinition {
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final Closure body;
    private final StackTraceElement location;
    private final Pattern pattern;
    private GroovyBackend backend;

    public GroovyStepDefinition(Pattern pattern, Closure body, StackTraceElement location, GroovyBackend backend) {
        this.pattern = pattern;
        this.backend = backend;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.body = body;
        this.location = location;
    }

    public List<Argument> matchedArguments(Step step) {
        return this.argumentMatcher.argumentsFrom(step.getName());
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public List<ParameterType> getParameterTypes() {
        Class[] parameterTypes = this.body.getParameterTypes();
        ArrayList<ParameterType> result = new ArrayList<ParameterType>(parameterTypes.length);
        for (Class parameterType : parameterTypes) {
            result.add(new ParameterType((Type)parameterType, null));
        }
        return result;
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        this.backend.invoke(this.body, args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }
}

