/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.io.ClasspathResourceLoader;
import cucumber.io.Resource;
import cucumber.io.ResourceLoader;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.groovy.GroovyHookDefinition;
import cucumber.runtime.groovy.GroovySnippet;
import cucumber.runtime.groovy.GroovyStepDefinition;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.TagExpression;
import gherkin.formatter.model.Step;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class GroovyBackend
implements Backend {
    static GroovyBackend instance;
    private final Set<Class> scripts = new HashSet<Class>();
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new GroovySnippet());
    private final ResourceLoader resourceLoader;
    private final GroovyShell shell;
    private final ClasspathResourceLoader classpathResourceLoader;
    private Closure worldClosure;
    private Object groovyWorld;
    private Glue glue;

    public GroovyBackend(ResourceLoader resourceLoader) {
        this(new GroovyShell(), resourceLoader);
    }

    public GroovyBackend(GroovyShell shell, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.shell = shell;
        instance = this;
        this.classpathResourceLoader = new ClasspathResourceLoader((ClassLoader)shell.getClassLoader());
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        Binding context = this.shell.getContext();
        for (String gluePath : gluePaths) {
            Script script;
            for (Resource resource : this.resourceLoader.resources(Utils.packagePath((String)gluePath), ".groovy")) {
                script = this.parse(resource);
                this.runIfScript(context, script);
            }
            for (Class glueClass : this.classpathResourceLoader.getDescendants(Script.class, Utils.toPackage((String)gluePath))) {
                try {
                    script = (Script)glueClass.getConstructor(Binding.class).newInstance(context);
                    this.runIfScript(context, script);
                }
                catch (Exception e) {
                    throw new CucumberException((Throwable)e);
                }
            }
        }
    }

    private void runIfScript(Binding context, Script script) {
        Class scriptClass = script.getMetaClass().getTheClass();
        if (this.isScript(script) && !this.scripts.contains(scriptClass)) {
            script.setBinding(context);
            script.run();
            this.scripts.add(scriptClass);
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
    }

    private Script parse(Resource resource) {
        try {
            return this.shell.parse((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"), resource.getPath());
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private boolean isScript(Script script) {
        return DefaultGroovyMethods.asBoolean((Collection)script.getMetaClass().respondsTo((Object)script, "main"));
    }

    public void disposeWorld() {
        this.groovyWorld = null;
    }

    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    public void addStepDefinition(Pattern regexp, Closure body) {
        this.glue.addStepDefinition((StepDefinition)new GroovyStepDefinition(regexp, body, GroovyBackend.stepDefLocation(), instance));
    }

    public void registerWorld(Closure closure) {
        this.worldClosure = closure;
    }

    void addBeforeHook(TagExpression tagExpression, Closure body) {
        this.glue.addBeforeHook((HookDefinition)new GroovyHookDefinition(body, tagExpression, instance));
    }

    public void addAfterHook(TagExpression tagExpression, Closure body) {
        this.glue.addAfterHook((HookDefinition)new GroovyHookDefinition(body, tagExpression, instance));
    }

    public void invoke(Closure body, Object[] args) {
        body.setDelegate(this.getGroovyWorld());
        body.call(args);
    }

    private Object getGroovyWorld() {
        if (this.groovyWorld == null) {
            this.groovyWorld = this.worldClosure == null ? new Object() : this.worldClosure.call();
        }
        return this.groovyWorld;
    }

    private static StackTraceElement stepDefLocation() {
        StackTraceElement[] stackTraceElements;
        Throwable t = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
            if (!GroovyBackend.isGroovyFile(stackTraceElement.getFileName())) continue;
            return stackTraceElement;
        }
        throw new RuntimeException("Couldn't find location for step definition");
    }

    private static boolean isGroovyFile(String fileName) {
        return fileName != null && fileName.endsWith(".groovy");
    }
}

