/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.runtime.HookDefinition;
import cucumber.runtime.ScenarioResult;
import cucumber.runtime.groovy.GroovyBackend;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import groovy.lang.Closure;
import java.util.Collection;

public class GroovyHookDefinition
implements HookDefinition {
    private final Closure body;
    private final TagExpression tagExpression;
    private final GroovyBackend backend;
    private final StackTraceElement location;

    public GroovyHookDefinition(Closure body, TagExpression tagExpression, StackTraceElement location, GroovyBackend backend) {
        this.body = body;
        this.tagExpression = tagExpression;
        this.location = location;
        this.backend = backend;
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public void execute(ScenarioResult scenarioResult) throws Throwable {
        this.backend.invoke(this.body, new Object[]{scenarioResult});
    }

    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.eval(tags);
    }

    public int getOrder() {
        return 0;
    }
}

