/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.groovy.GroovyHookDefinition;
import cucumber.runtime.groovy.GroovySnippet;
import cucumber.runtime.groovy.GroovyStepDefinition;
import cucumber.runtime.io.ClasspathResourceLoader;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.TagExpression;
import gherkin.formatter.model.Step;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class GroovyBackend
implements Backend {
    public static GroovyBackend instance;
    private final Set<Class> scripts = new HashSet<Class>();
    private final SnippetGenerator snippetGenerator = new SnippetGenerator(new GroovySnippet());
    private final ResourceLoader resourceLoader;
    private final GroovyShell shell;
    private final ClasspathResourceLoader classpathResourceLoader;
    private Closure worldClosure;
    private Object world;
    private Glue glue;

    private static GroovyShell createShell() {
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        return new GroovyShell(Thread.currentThread().getContextClassLoader(), new Binding(), compilerConfig);
    }

    public GroovyBackend(ResourceLoader resourceLoader) {
        this(GroovyBackend.createShell(), resourceLoader);
    }

    public GroovyBackend(GroovyShell shell, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.shell = shell;
        instance = this;
        this.classpathResourceLoader = new ClasspathResourceLoader((ClassLoader)shell.getClassLoader());
    }

    @Override
    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        Binding context = this.shell.getContext();
        for (String gluePath : gluePaths) {
            Script script;
            for (Resource resource : this.resourceLoader.resources(gluePath, ".groovy")) {
                script = this.parse(resource);
                this.runIfScript(context, script);
            }
            for (Class clazz : this.classpathResourceLoader.getDescendants(Script.class, MultiLoader.packageName(gluePath))) {
                try {
                    script = (Script)clazz.getConstructor(Binding.class).newInstance(context);
                    this.runIfScript(context, script);
                }
                catch (Exception e) {
                    throw new CucumberException(e);
                }
            }
        }
    }

    private void runIfScript(Binding context, Script script) {
        Class scriptClass = script.getMetaClass().getTheClass();
        if (this.isScript(script) && !this.scripts.contains(scriptClass)) {
            script.setBinding(context);
            script.run();
            this.scripts.add(scriptClass);
        }
    }

    @Override
    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    @Override
    public void buildWorld() {
        this.world = this.worldClosure == null ? new Object() : this.worldClosure.call();
    }

    private Script parse(Resource resource) {
        try {
            return this.shell.parse((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"), resource.getPath());
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private boolean isScript(Script script) {
        return DefaultGroovyMethods.asBoolean((Collection)script.getMetaClass().respondsTo((Object)script, "main"));
    }

    @Override
    public void disposeWorld() {
        this.world = null;
    }

    @Override
    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    public void addStepDefinition(Pattern regexp, int timeoutMillis, Closure body) {
        this.glue.addStepDefinition(new GroovyStepDefinition(regexp, timeoutMillis, body, GroovyBackend.currentLocation(), instance));
    }

    public void registerWorld(Closure closure) {
        if (this.worldClosure != null) {
            throw new CucumberException("World is already set");
        }
        this.worldClosure = closure;
    }

    public void addBeforeHook(TagExpression tagExpression, int timeoutMillis, Closure body) {
        this.glue.addBeforeHook(new GroovyHookDefinition(tagExpression, timeoutMillis, body, GroovyBackend.currentLocation(), instance));
    }

    public void addAfterHook(TagExpression tagExpression, int timeoutMillis, Closure body) {
        this.glue.addAfterHook(new GroovyHookDefinition(tagExpression, timeoutMillis, body, GroovyBackend.currentLocation(), instance));
    }

    public void invoke(Closure body, Object[] args) throws Throwable {
        body.setDelegate(this.world);
        try {
            body.call(args);
        }
        catch (InvokerInvocationException e) {
            throw e.getCause();
        }
    }

    private static StackTraceElement currentLocation() {
        StackTraceElement[] stackTraceElements;
        Throwable t = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
            if (!GroovyBackend.isGroovyFile(stackTraceElement.getFileName())) continue;
            return stackTraceElement;
        }
        throw new RuntimeException("Couldn't find location for step definition");
    }

    private static boolean isGroovyFile(String fileName) {
        return fileName != null && fileName.endsWith(".groovy");
    }
}

