/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.List;

public class StepContainer {
    private final List<Step> steps = new ArrayList<Step>();
    final CucumberFeature cucumberFeature;
    private final BasicStatement statement;

    StepContainer(CucumberFeature cucumberFeature, BasicStatement statement) {
        this.cucumberFeature = cucumberFeature;
        this.statement = statement;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void step(Step step) {
        this.steps.add(step);
    }

    void format(Formatter formatter) {
        this.statement.replay(formatter);
    }

    void formatSteps(Formatter formatter) {
        for (Step step : this.getSteps()) {
            formatter.step(step);
        }
    }

    void runSteps(Formatter formatter, Reporter reporter, Runtime runtime) {
        for (Step step : this.getSteps()) {
            this.runStep(step, formatter, reporter, runtime);
        }
    }

    void runStep(Step step, Formatter formatter, Reporter reporter, Runtime runtime) {
        formatter.step(step);
        runtime.runStep(this.cucumberFeature.getUri(), step, reporter, this.cucumberFeature.getI18n());
    }
}

