/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.groovy;

import cucumber.runtime.groovy.GroovyBackend;
import gherkin.TagExpression;
import groovy.lang.Closure;
import java.util.ArrayList;

public class Hooks {
    public static void World(Closure body) throws Throwable {
        GroovyBackend.getInstance().registerWorld(body);
    }

    public static void Before(Object ... args) throws Throwable {
        Hooks.addHook(args, true);
    }

    public static void After(Object ... args) throws Throwable {
        Hooks.addHook(args, false);
    }

    private static void addHook(Object[] tagsExpressionsAndBody, boolean before) {
        ArrayList<String> tagExpressions = new ArrayList<String>();
        int timeoutMillis = 0;
        Closure body = null;
        for (Object o : tagsExpressionsAndBody) {
            if (o instanceof String) {
                tagExpressions.add((String)o);
                continue;
            }
            if (o instanceof Integer) {
                timeoutMillis = (Integer)o;
                continue;
            }
            if (!(o instanceof Closure)) continue;
            body = (Closure)o;
        }
        TagExpression tagExpression = new TagExpression(tagExpressions);
        if (before) {
            GroovyBackend.getInstance().addBeforeHook(tagExpression, timeoutMillis, body);
        } else {
            GroovyBackend.getInstance().addAfterHook(tagExpression, timeoutMillis, body);
        }
    }
}

