/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.ioke;

import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterType;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.ioke.IokeBackend;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import ioke.lang.IokeObject;
import ioke.lang.Runtime;
import ioke.lang.exceptions.ControlFlow;
import java.util.List;

public class IokeStepDefinition
implements StepDefinition {
    private final Runtime ioke;
    private final IokeObject iokeStepDefObject;
    private final IokeBackend backend;
    private final String location;

    public IokeStepDefinition(IokeBackend iokeBackend, Runtime ioke, IokeObject iokeStepDefObject, String location) throws Throwable {
        this.ioke = ioke;
        this.iokeStepDefObject = iokeStepDefObject;
        this.backend = iokeBackend;
        this.location = location;
    }

    public String getPattern() {
        try {
            IokeObject regexp = (IokeObject)this.backend.invoke(this.iokeStepDefObject, "regexp_pattern", new Object[0]);
            return regexp.toString();
        }
        catch (ControlFlow controlFlow) {
            throw new CucumberException("Couldn't get pattern", (Throwable)controlFlow);
        }
    }

    public List<Argument> matchedArguments(Step step) {
        try {
            Object args = this.backend.invoke(this.iokeStepDefObject, "arguments_from", step.getName());
            if (args.equals(this.ioke.nil)) {
                return null;
            }
            return (List)args;
        }
        catch (ControlFlow controlFlow) {
            throw new RuntimeException("Failed to get step args", controlFlow);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public List<ParameterType> getParameterTypes() {
        try {
            IokeObject argNames = (IokeObject)this.backend.invoke(this.iokeStepDefObject, "arg_names", new Object[0]);
            IokeObject argLength = (IokeObject)this.backend.invoke(argNames, "length", new Object[0]);
            int groupCount = Integer.parseInt(argLength.toString());
            return Utils.listOf((int)groupCount, (Object)new ParameterType(String.class, null));
        }
        catch (ControlFlow controlFlow) {
            throw new CucumberException("Couldn't inspect arity of stepdef", (Throwable)controlFlow);
        }
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        this.backend.execute(this.iokeStepDefObject, args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().equals(IokeBackend.class.getName());
    }
}

