/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.ioke;

import cucumber.io.Resource;
import cucumber.io.ResourceLoader;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.ioke.IokeSnippet;
import cucumber.runtime.ioke.IokeStepDefinition;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import cucumber.table.DataTable;
import gherkin.formatter.model.Step;
import ioke.lang.IokeObject;
import ioke.lang.Message;
import ioke.lang.Runtime;
import ioke.lang.exceptions.ControlFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IokeBackend
implements Backend {
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new IokeSnippet());
    private final ResourceLoader resourceLoader;
    private final Runtime ioke;
    private final List<Runtime.RescueInfo> failureRescues;
    private final List<Runtime.RescueInfo> pendingRescues;
    private String currentLocation;
    private Glue glue;

    public IokeBackend(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        try {
            this.ioke = new Runtime();
            this.ioke.init();
            this.ioke.ground.setCell("IokeBackend", (Object)this);
            this.ioke.evaluateString("use(\"cucumber/runtime/ioke/dsl\")");
            this.failureRescues = this.createRescues("ISpec", "ExpectationNotMet");
            this.pendingRescues = this.createRescues("Pending");
        }
        catch (Throwable e) {
            throw new CucumberException("Failed to initialize Ioke", e);
        }
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        for (String gluePath : gluePaths) {
            for (Resource resource : this.resourceLoader.resources(gluePath, ".ik")) {
                this.currentLocation = resource.getPath();
                this.evaluate(resource);
            }
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
    }

    private void evaluate(Resource resource) {
        try {
            String path = resource.getPath().replace('\\', '/');
            this.ioke.evaluateString("use(\"" + path + "\")");
        }
        catch (ControlFlow controlFlow) {
            throw new CucumberException((Throwable)controlFlow);
        }
    }

    public void disposeWorld() {
    }

    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    public void addStepDefinition(Object iokeStepDefObject) throws Throwable {
        this.glue.addStepDefinition((StepDefinition)new IokeStepDefinition(this, this.ioke, (IokeObject)iokeStepDefObject, this.currentLocation));
    }

    private List<Runtime.RescueInfo> createRescues(String ... names) throws ControlFlow {
        IokeObject condition = IokeObject.as((Object)IokeObject.getCellChain((Object)this.ioke.condition, (IokeObject)this.ioke.message, (IokeObject)this.ioke.ground, (String[])names), (IokeObject)this.ioke.ground);
        ArrayList<Runtime.RescueInfo> rescues = new ArrayList<Runtime.RescueInfo>();
        IokeObject rr = IokeObject.as((Object)((Message)IokeObject.data((Object)this.ioke.mimic)).sendTo(this.ioke.mimic, this.ioke.ground, (Object)this.ioke.rescue), (IokeObject)this.ioke.ground);
        ArrayList<IokeObject> conds = new ArrayList<IokeObject>();
        conds.add(condition);
        rescues.add(new Runtime.RescueInfo(rr, conds, rescues, this.ioke.getBindIndex()));
        return rescues;
    }

    void execute(IokeObject iokeStepDefObject, Object[] args) throws Throwable {
        try {
            this.ioke.registerRescues(this.failureRescues);
            this.ioke.registerRescues(this.pendingRescues);
            this.invoke(iokeStepDefObject, "invoke", this.multilineArg(args));
        }
        catch (ControlFlow.Rescue e) {
            if (e.getRescue().token == this.pendingRescues) {
                throw e;
            }
            if (e.getRescue().token == this.failureRescues) {
                Message message = (Message)IokeObject.data((Object)this.ioke.reportMessage);
                String errorMessage = message.sendTo(this.ioke.reportMessage, this.ioke.ground, (Object)e.getCondition()).toString();
                throw new AssertionError((Object)errorMessage);
            }
            throw e;
        }
        finally {
            this.ioke.unregisterRescues(this.failureRescues);
            this.ioke.unregisterRescues(this.pendingRescues);
        }
    }

    private Object multilineArg(Object[] args) {
        Object multilineArg = args.length > 0 ? (args[args.length - 1] instanceof String ? this.ioke.newText((String)args[args.length - 1]) : (args[args.length - 1] instanceof DataTable ? args[args.length - 1] : this.ioke.nil)) : this.ioke.nil;
        return multilineArg;
    }

    Object invoke(IokeObject iokeStepDefObject, String message, Object ... args) throws ControlFlow {
        IokeObject msg = this.ioke.newMessage(message);
        Message m = (Message)IokeObject.data((Object)msg);
        return m.sendTo(msg, iokeStepDefObject, (Object)iokeStepDefObject, Arrays.asList(args));
    }
}

