/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.annotation.After;
import cucumber.annotation.Before;
import cucumber.annotation.Order;
import cucumber.io.ClasspathResourceLoader;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.StepDefAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public class ClasspathMethodScanner {
    private final ClasspathResourceLoader resourceLoader;

    public ClasspathMethodScanner(ClasspathResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void scan(JavaBackend javaBackend, List<String> gluePaths) {
        Collection<Class<? extends Annotation>> cucumberAnnotationClasses = this.findCucumberAnnotationClasses();
        for (String gluePath : gluePaths) {
            String packageName = gluePath.replace('/', '.').replace('\\', '.');
            for (Class candidateClass : this.resourceLoader.getDescendants(Object.class, packageName)) {
                for (Method method : candidateClass.getMethods()) {
                    this.scan(method, cucumberAnnotationClasses, javaBackend);
                }
            }
        }
    }

    private Collection<Class<? extends Annotation>> findCucumberAnnotationClasses() {
        return this.resourceLoader.getAnnotations("cucumber.annotation");
    }

    private void scan(Method method, Collection<Class<? extends Annotation>> cucumberAnnotationClasses, JavaBackend javaBackend) {
        for (Class<? extends Annotation> cucumberAnnotationClass : cucumberAnnotationClasses) {
            Annotation annotation = method.getAnnotation(cucumberAnnotationClass);
            if (annotation == null || annotation.annotationType().equals(Order.class)) continue;
            if (this.isHookAnnotation(annotation)) {
                javaBackend.addHook(annotation, method);
                continue;
            }
            if (!this.isStepdefAnnotation(annotation)) continue;
            javaBackend.addStepDefinition(annotation, method);
        }
    }

    private boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(After.class);
    }

    private boolean isStepdefAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefAnnotation.class) != null;
    }
}

