/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.annotation.DateFormat;
import cucumber.annotation.Pending;
import cucumber.runtime.CucumberException;
import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.ParameterType;
import cucumber.runtime.PendingException;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.java.MethodFormat;
import cucumber.runtime.java.ObjectFactory;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class JavaStepDefinition
implements StepDefinition {
    private static final MethodFormat METHOD_FORMAT = new MethodFormat();
    private final Method method;
    private final Pattern pattern;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final ObjectFactory objectFactory;

    public JavaStepDefinition(Method method, Pattern pattern, ObjectFactory objectFactory) {
        this.method = method;
        this.pattern = pattern;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.objectFactory = objectFactory;
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        if (this.method.isAnnotationPresent(Pending.class)) {
            throw new PendingException(this.method.getAnnotation(Pending.class).value());
        }
        Class<?> clazz = this.method.getDeclaringClass();
        Object target = this.objectFactory.getInstance(clazz);
        try {
            this.method.invoke(target, args);
        }
        catch (IllegalArgumentException e) {
            throw new CucumberException("Can't invoke " + new MethodFormat().format(this.method) + " with " + Arrays.asList(args));
        }
        catch (InvocationTargetException t) {
            throw t.getTargetException();
        }
    }

    public List<Argument> matchedArguments(Step step) {
        return this.argumentMatcher.argumentsFrom(step.getName());
    }

    public String getLocation() {
        return METHOD_FORMAT.format(this.method);
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> result = new ArrayList<ParameterType>();
        Type[] genericParameterTypes = this.method.getGenericParameterTypes();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            String dateFormat = null;
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof DateFormat)) continue;
                dateFormat = ((DateFormat)annotation).value();
                break;
            }
            result.add(new ParameterType(genericParameterTypes[i], dateFormat));
        }
        return result;
    }

    public boolean isDefinedAt(StackTraceElement e) {
        return e.getClassName().equals(this.method.getDeclaringClass().getName()) && e.getMethodName().equals(this.method.getName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }
}

