/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.annotation.After;
import cucumber.annotation.Before;
import cucumber.annotation.Order;
import cucumber.io.ClasspathResourceLoader;
import cucumber.runtime.Utils;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.StepDefAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ClasspathMethodScanner {
    private final ClasspathResourceLoader resourceLoader;

    public ClasspathMethodScanner(ClasspathResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void scan(JavaBackend javaBackend, List<String> gluePaths) {
        Collection<Class<? extends Annotation>> cucumberAnnotationClasses = this.findCucumberAnnotationClasses();
        for (String gluePath : gluePaths) {
            String packageName = gluePath.replace('/', '.').replace('\\', '.');
            Iterator i$ = this.resourceLoader.getDescendants(Object.class, packageName).iterator();
            while (i$.hasNext()) {
                Class glueCodeClass;
                for (glueCodeClass = (Class)i$.next(); glueCodeClass != null && glueCodeClass != Object.class && !Utils.isInstantiable((Class)glueCodeClass); glueCodeClass = glueCodeClass.getSuperclass()) {
                }
                if (glueCodeClass == null) continue;
                for (Method method : glueCodeClass.getMethods()) {
                    this.scan(glueCodeClass, method, cucumberAnnotationClasses, javaBackend);
                }
            }
        }
    }

    private Collection<Class<? extends Annotation>> findCucumberAnnotationClasses() {
        return this.resourceLoader.getAnnotations("cucumber.annotation");
    }

    private void scan(Class<?> glueCodeClass, Method method, Collection<Class<? extends Annotation>> cucumberAnnotationClasses, JavaBackend javaBackend) {
        for (Class<? extends Annotation> cucumberAnnotationClass : cucumberAnnotationClasses) {
            Annotation annotation = method.getAnnotation(cucumberAnnotationClass);
            if (annotation == null || annotation.annotationType().equals(Order.class)) continue;
            if (this.isHookAnnotation(annotation)) {
                javaBackend.addHook(annotation, glueCodeClass, method);
                continue;
            }
            if (!this.isStepdefAnnotation(annotation)) continue;
            javaBackend.addStepDefinition(annotation, glueCodeClass, method);
        }
    }

    private boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(After.class);
    }

    private boolean isStepdefAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefAnnotation.class) != null;
    }
}

