/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.annotation.After;
import cucumber.annotation.Before;
import cucumber.annotation.Order;
import cucumber.fallback.runtime.java.DefaultJavaObjectFactory;
import cucumber.io.ClasspathResourceLoader;
import cucumber.io.ResourceLoader;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.World;
import cucumber.runtime.java.ClasspathMethodScanner;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.java.ObjectFactoryHolder;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class JavaBackend
implements Backend {
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new JavaSnippet());
    private final Set<Class> stepDefinitionClasses = new HashSet<Class>();
    private final ObjectFactory objectFactory;
    private final ClasspathMethodScanner classpathMethodScanner = new ClasspathMethodScanner();
    private World world;

    public JavaBackend(ResourceLoader ignored) {
        ObjectFactory foundOF;
        if (ObjectFactoryHolder.getFactory() != null) {
            foundOF = ObjectFactoryHolder.getFactory();
        } else {
            try {
                foundOF = (ObjectFactory)new ClasspathResourceLoader().instantiateExactlyOneSubclass(ObjectFactory.class, "cucumber/runtime", new Class[0], new Object[0]);
            }
            catch (CucumberException ce) {
                foundOF = new DefaultJavaObjectFactory();
            }
        }
        this.objectFactory = foundOF;
    }

    public JavaBackend(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void buildWorld(List<String> gluePaths, World world) {
        this.world = world;
        this.classpathMethodScanner.scan(this, gluePaths);
        this.objectFactory.createInstances();
    }

    public void disposeWorld() {
        this.objectFactory.disposeInstances();
    }

    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    void addStepDefinition(Annotation annotation, Method method) {
        try {
            Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
            String regexpString = (String)regexpMethod.invoke((Object)annotation, new Object[0]);
            if (regexpString != null) {
                Pattern pattern = Pattern.compile(regexpString);
                Class<?> clazz = method.getDeclaringClass();
                this.registerClassInObjectFactory(clazz);
                this.world.addStepDefinition((StepDefinition)new JavaStepDefinition(method, pattern, this.objectFactory));
            }
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CucumberException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    void addHook(Annotation annotation, Method method) {
        int hookOrder;
        Class<?> clazz = method.getDeclaringClass();
        this.registerClassInObjectFactory(clazz);
        Order order = method.getAnnotation(Order.class);
        int n = hookOrder = order == null ? Integer.MAX_VALUE : order.value();
        if (annotation.annotationType().equals(Before.class)) {
            String[] tagExpressions = ((Before)annotation).value();
            this.world.addBeforeHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, hookOrder, this.objectFactory));
        } else {
            String[] tagExpressions = ((After)annotation).value();
            this.world.addAfterHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, hookOrder, this.objectFactory));
        }
    }

    private void registerClassInObjectFactory(Class<?> clazz) {
        if (!this.stepDefinitionClasses.contains(clazz)) {
            this.objectFactory.addClass(clazz);
            this.stepDefinitionClasses.add(clazz);
            this.addConstructorDependencies(clazz);
        }
    }

    private void addConstructorDependencies(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            for (Class<?> paramClazz : constructor.getParameterTypes()) {
                this.registerClassInObjectFactory(paramClazz);
            }
        }
    }
}

