/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.runtime.CucumberException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.ScenarioResult;
import cucumber.runtime.java.MethodFormat;
import cucumber.runtime.java.ObjectFactory;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

public class JavaHookDefinition
implements HookDefinition {
    private final Method method;
    private final TagExpression tagExpression;
    private final int order;
    private final ObjectFactory objectFactory;

    public JavaHookDefinition(Method method, String[] tagExpressions, int order, ObjectFactory objectFactory) {
        this.method = method;
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.order = order;
        this.objectFactory = objectFactory;
    }

    Method getMethod() {
        return this.method;
    }

    public void execute(ScenarioResult scenarioResult) throws Throwable {
        Object target = this.objectFactory.getInstance(this.method.getDeclaringClass());
        if (target == null) {
            throw new IllegalStateException("Bug: No target for " + this.method);
        }
        Object[] args = this.method.getParameterTypes().length == 1 ? new Object[]{scenarioResult} : new Object[]{};
        try {
            this.method.invoke(target, args);
        }
        catch (IllegalArgumentException e) {
            throw new CucumberException("Can't invoke " + new MethodFormat().format(this.method));
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.eval(tags);
    }

    public int getOrder() {
        return this.order;
    }
}

