/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.runtime.HookDefinition;
import cucumber.runtime.ScenarioResult;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.util.Arrays;
import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyHookDefinition
implements HookDefinition {
    private final TagExpression tagExpression;
    private final RubyObject hook;

    public JRubyHookDefinition(String[] tagExpressions, RubyObject hook) {
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.hook = hook;
    }

    public void execute(ScenarioResult scenarioResult) throws Throwable {
        IRubyObject[] jrybyArgs = new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)this.hook.getRuntime(), (Object)scenarioResult)};
        this.hook.callMethod("execute", jrybyArgs);
    }

    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.eval(tags);
    }

    public int getOrder() {
        return 0;
    }
}

