/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.runtime.ParameterType;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.table.DataTable;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyStepDefinition
implements StepDefinition {
    private final RubyObject stepdef;
    private String file;
    private Long line;

    public JRubyStepDefinition(RubyObject stepdef) {
        this.stepdef = stepdef;
    }

    public List<Argument> matchedArguments(Step step) {
        RubyString stepName = this.stepdef.getRuntime().newString(step.getName());
        IRubyObject arguments = this.stepdef.callMethod("matched_arguments", new IRubyObject[]{stepName});
        return (List)arguments.toJava(List.class);
    }

    public String getLocation() {
        if (this.file == null) {
            List fileAndLine = (List)this.stepdef.callMethod("file_and_line").toJava(List.class);
            this.file = (String)fileAndLine.get(0);
            this.line = (Long)fileAndLine.get(1);
        }
        return this.file + ":" + this.line;
    }

    public List<ParameterType> getParameterTypes() {
        IRubyObject argCountR = this.stepdef.callMethod("arg_count");
        int argCount = (Integer)argCountR.toJava(Integer.class);
        return Utils.listOf((int)Math.max(0, argCount), (Object)new ParameterType(String.class, null));
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        ArrayList<Object> jrubyArgs = new ArrayList<Object>();
        jrubyArgs.add(JavaEmbedUtils.javaToRuby((Ruby)this.stepdef.getRuntime(), (Object)i18n));
        for (Object o : args) {
            if (o == null) {
                jrubyArgs.add(null);
                continue;
            }
            if (o instanceof DataTable) {
                jrubyArgs.add(JavaEmbedUtils.javaToRuby((Ruby)this.stepdef.getRuntime(), (Object)o));
                continue;
            }
            jrubyArgs.add(this.stepdef.getRuntime().newString((String)o));
        }
        this.stepdef.callMethod("execute", jrubyArgs.toArray(new IRubyObject[jrubyArgs.size()]));
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.file.equals(stackTraceElement.getFileName()) && this.line < (long)stackTraceElement.getLineNumber();
    }

    public String getPattern() {
        return (String)this.stepdef.callMethod("pattern").toJava(String.class);
    }
}

