/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.io.Resource;
import cucumber.io.ResourceLoader;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.PendingException;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.World;
import cucumber.runtime.jruby.JRubyHookDefinition;
import cucumber.runtime.jruby.JRubySnippet;
import cucumber.runtime.jruby.JRubyStepDefinition;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.jruby.CompatVersion;
import org.jruby.RubyObject;
import org.jruby.embed.ScriptingContainer;

public class JRubyBackend
implements Backend {
    private static final String DSL = "/cucumber/runtime/jruby/dsl.rb";
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new JRubySnippet());
    private final ScriptingContainer jruby = new ScriptingContainer();
    private World world;
    private ResourceLoader resourceLoader;

    public JRubyBackend(ResourceLoader resourceLoader) throws UnsupportedEncodingException {
        String rubyVersion;
        this.resourceLoader = resourceLoader;
        this.jruby.put("$backend", (Object)this);
        this.jruby.setClassLoader(this.getClass().getClassLoader());
        Properties props = new Properties();
        InputStream propsStream = this.getClass().getResourceAsStream("/cucumber-jruby.properties");
        try {
            if (propsStream != null) {
                props.load(propsStream);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String gemPath = props.getProperty("GEM_PATH");
        if (gemPath != null && !gemPath.isEmpty()) {
            this.jruby.runScriptlet("ENV['GEM_PATH']='" + gemPath + "'");
        }
        if ("1.9".equals(rubyVersion = props.getProperty("RUBY_VERSION"))) {
            this.jruby.setCompatVersion(CompatVersion.RUBY1_9);
        }
        this.jruby.runScriptlet((Reader)new InputStreamReader(this.getClass().getResourceAsStream(DSL), "UTF-8"), DSL);
    }

    public void buildWorld(List<String> gluePaths, World world) {
        this.world = world;
        this.jruby.put("$world", new Object());
        for (String gluePath : gluePaths) {
            for (Resource resource : this.resourceLoader.resources(gluePath, ".rb")) {
                this.runScriptlet(resource);
            }
        }
    }

    private void runScriptlet(Resource resource) {
        try {
            this.jruby.runScriptlet((Reader)new InputStreamReader(resource.getInputStream()), resource.getPath());
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    public void disposeWorld() {
    }

    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    public void pending(String reason) throws PendingException {
        throw new PendingException(reason);
    }

    public void runStep(String uri, Locale locale, String stepKeyword, String stepName, int line) throws Throwable {
        this.world.runUnreportedStep(uri, locale, stepKeyword, stepName, line);
    }

    public void addStepdef(RubyObject stepdef) {
        this.world.addStepDefinition((StepDefinition)new JRubyStepDefinition(stepdef));
    }

    public void addBeforeHook(RubyObject body) {
        this.world.addBeforeHook((HookDefinition)new JRubyHookDefinition(new String[0], body));
    }

    public void addAfterHook(RubyObject body) {
        this.world.addAfterHook((HookDefinition)new JRubyHookDefinition(new String[0], body));
    }
}

