/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.Backend;
import gherkin.I18n;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UndefinedStepsTracker {
    private final List<Step> undefinedSteps = new ArrayList<Step>();
    private String lastGivenWhenThenStepKeyword;

    public void reset() {
        this.lastGivenWhenThenStepKeyword = null;
    }

    public List<String> getSnippets(Iterable<? extends Backend> backends) {
        ArrayList<String> snippets = new ArrayList<String>();
        for (Step step : this.undefinedSteps) {
            for (Backend backend : backends) {
                String snippet = backend.getSnippet(step);
                if (snippets.contains(snippet)) continue;
                snippets.add(snippet);
            }
        }
        return snippets;
    }

    public void storeStepKeyword(Step step, I18n i18n) {
        String keyword = step.getKeyword();
        if (this.isGivenWhenThenKeyword(keyword, i18n)) {
            this.lastGivenWhenThenStepKeyword = keyword;
        }
        if (this.lastGivenWhenThenStepKeyword == null) {
            this.lastGivenWhenThenStepKeyword = keyword;
        }
    }

    public void addUndefinedStep(Step step, I18n i18n) {
        this.undefinedSteps.add(this.givenWhenThenStep(step, i18n));
    }

    private boolean isGivenWhenThenKeyword(String keyword, I18n i18n) {
        for (String gwts : Arrays.asList("given", "when", "then")) {
            List<String> keywords = i18n.keywords(gwts);
            if (!keywords.contains(keyword) || "* ".equals(keyword)) continue;
            return true;
        }
        return false;
    }

    private Step givenWhenThenStep(Step step, I18n i18n) {
        if (this.isGivenWhenThenKeyword(step.getKeyword(), i18n)) {
            return step;
        }
        if (this.lastGivenWhenThenStepKeyword == null) {
            ArrayList<String> givenKeywords = new ArrayList<String>(i18n.keywords("given"));
            givenKeywords.remove("* ");
            this.lastGivenWhenThenStepKeyword = (String)givenKeywords.get(0);
        }
        return new Step(step.getComments(), this.lastGivenWhenThenStepKeyword, step.getName(), step.getLine(), step.getRows(), step.getDocString());
    }

    public boolean hasUndefinedSteps() {
        return !this.undefinedSteps.isEmpty();
    }
}

