/*
 * Decompiled with CFR 0.152.
 */
package cucumber.formatter;

import cucumber.formatter.ColorAware;
import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.ansi.AnsiEscapes;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProgressFormatter
implements Formatter,
Reporter,
ColorAware {
    private static final Map<String, Character> CHARS = new HashMap<String, Character>(){
        {
            this.put("passed", Character.valueOf('.'));
            this.put("undefined", Character.valueOf('U'));
            this.put("pending", Character.valueOf('P'));
            this.put("skipped", Character.valueOf('-'));
            this.put("failed", Character.valueOf('F'));
        }
    };
    private static final Map<String, AnsiEscapes> ANSI_ESCAPES = new HashMap<String, AnsiEscapes>(){
        {
            this.put("passed", AnsiEscapes.GREEN);
            this.put("undefined", AnsiEscapes.YELLOW);
            this.put("pending", AnsiEscapes.YELLOW);
            this.put("skipped", AnsiEscapes.CYAN);
            this.put("failed", AnsiEscapes.RED);
        }
    };
    private final NiceAppendable out;
    private boolean monochrome = false;

    public ProgressFormatter(Appendable appendable) {
        this.out = new NiceAppendable(appendable);
    }

    @Override
    public void uri(String uri) {
    }

    @Override
    public void feature(Feature feature) {
    }

    @Override
    public void background(Background background) {
    }

    @Override
    public void scenario(Scenario scenario) {
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    @Override
    public void examples(Examples examples) {
    }

    @Override
    public void step(Step step) {
    }

    @Override
    public void eof() {
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    @Override
    public void done() {
        this.out.println();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void result(Result result) {
        if (!this.monochrome) {
            ANSI_ESCAPES.get(result.getStatus()).appendTo(this.out);
        }
        this.out.append(CHARS.get(result.getStatus()).charValue());
        if (!this.monochrome) {
            AnsiEscapes.RESET.appendTo(this.out);
        }
    }

    @Override
    public void before(Match match, Result result) {
        this.handleHook(match, result, "B");
    }

    @Override
    public void after(Match match, Result result) {
        this.handleHook(match, result, "A");
    }

    private void handleHook(Match match, Result result, String character) {
        if (result.getStatus().equals("failed")) {
            if (!this.monochrome) {
                ANSI_ESCAPES.get(result.getStatus()).appendTo(this.out);
            }
            this.out.append(character);
            if (!this.monochrome) {
                AnsiEscapes.RESET.appendTo(this.out);
            }
        }
    }

    @Override
    public void match(Match match) {
    }

    @Override
    public void embedding(String mimeType, byte[] data) {
    }

    @Override
    public void write(String text) {
    }

    @Override
    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }
}

