/*
 * Decompiled with CFR 0.152.
 */
package cucumber.io;

import cucumber.io.ClasspathIterable;
import cucumber.io.Resource;
import cucumber.io.ResourceIteratorFactory;
import cucumber.io.ZipResourceIterator;
import cucumber.runtime.CucumberException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

public class ZipResourceIteratorFactory
implements ResourceIteratorFactory {
    @Override
    public boolean isFactoryFor(URL url) {
        return "jar".equals(url.getProtocol());
    }

    @Override
    public Iterator<Resource> createIterator(URL url, String path, String suffix) {
        try {
            String jarPath = ClasspathIterable.filePath(url);
            return new ZipResourceIterator(jarPath, path, suffix);
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }
}

