/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.io.Resource;
import cucumber.io.ResourceLoader;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.PendingException;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.jruby.JRubyHookDefinition;
import cucumber.runtime.jruby.JRubySnippet;
import cucumber.runtime.jruby.JRubyStepDefinition;
import cucumber.runtime.jruby.JRubyWorldBlock;
import cucumber.runtime.snippets.SnippetGenerator;
import cucumber.table.DataTable;
import gherkin.I18n;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.RubyObject;
import org.jruby.embed.ScriptingContainer;

public class JRubyBackend
implements Backend {
    private static final String DSL = "/cucumber/runtime/jruby/dsl.rb";
    private final SnippetGenerator snippetGenerator = new SnippetGenerator(new JRubySnippet());
    private final ScriptingContainer jruby = new ScriptingContainer();
    private Glue glue;
    private ResourceLoader resourceLoader;
    private UnreportedStepExecutor unreportedStepExecutor;
    private final Set<JRubyWorldBlock> worldBlocks = new HashSet<JRubyWorldBlock>();

    public JRubyBackend(ResourceLoader resourceLoader) throws UnsupportedEncodingException {
        this.resourceLoader = resourceLoader;
        this.jruby.put("$backend", (Object)this);
        this.jruby.setClassLoader(this.getClass().getClassLoader());
        try {
            String rubyVersion;
            ResourceBundle bundle = ResourceBundle.getBundle("cucumber-jruby");
            String gemPath = bundle.getString("GEM_PATH");
            if (gemPath != null && !gemPath.isEmpty()) {
                this.jruby.runScriptlet("ENV['GEM_PATH']='" + gemPath + "'");
            }
            if ("1.9".equals(rubyVersion = bundle.getString("RUBY_VERSION"))) {
                this.jruby.setCompatVersion(CompatVersion.RUBY1_9);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.jruby.runScriptlet((Reader)new InputStreamReader(this.getClass().getResourceAsStream(DSL), "UTF-8"), DSL);
    }

    @Override
    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        for (String gluePath : gluePaths) {
            for (Resource resource : this.resourceLoader.resources(gluePath, ".rb")) {
                this.runScriptlet(resource);
            }
        }
    }

    @Override
    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
        this.unreportedStepExecutor = executor;
    }

    @Override
    public void buildWorld() {
        this.jruby.put("$world", new Object());
        for (JRubyWorldBlock block : this.worldBlocks) {
            block.execute();
        }
    }

    private void runScriptlet(Resource resource) {
        try {
            this.jruby.runScriptlet((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"), resource.getPath());
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    @Override
    public void disposeWorld() {
    }

    @Override
    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    public void pending(String reason) throws PendingException {
        throw new PendingException(reason);
    }

    public void runStep(String uri, I18n i18n, String stepKeyword, String stepName, int line, DataTable dataTable, DocString docString) throws Throwable {
        List<DataTableRow> dataTableRows = null;
        if (dataTable != null) {
            dataTableRows = dataTable.getGherkinRows();
        }
        this.unreportedStepExecutor.runUnreportedStep(uri, i18n, stepKeyword, stepName, line, dataTableRows, docString);
    }

    public void addStepdef(RubyObject stepdef) {
        this.glue.addStepDefinition(new JRubyStepDefinition(stepdef));
    }

    public void addBeforeHook(RubyObject body) {
        this.glue.addBeforeHook(new JRubyHookDefinition(new String[0], body));
    }

    public void addAfterHook(RubyObject body) {
        this.glue.addAfterHook(new JRubyHookDefinition(new String[0], body));
    }

    public void addWorldBlock(RubyObject body) {
        this.worldBlocks.add(new JRubyWorldBlock(body));
    }
}

