/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.runtime.HookDefinition;
import cucumber.runtime.ScenarioResult;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyHookDefinition
implements HookDefinition {
    private final TagExpression tagExpression;
    private final RubyObject hook;
    private String file;
    private Long line;

    public JRubyHookDefinition(String[] tagExpressions, RubyObject hook) {
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.hook = hook;
    }

    @Override
    public String getLocation(boolean detail) {
        if (this.file == null) {
            List fileAndLine = (List)this.hook.callMethod("file_and_line").toJava(List.class);
            this.file = (String)fileAndLine.get(0);
            this.line = (Long)fileAndLine.get(1);
        }
        return this.file + ":" + this.line;
    }

    @Override
    public void execute(ScenarioResult scenarioResult) throws Throwable {
        IRubyObject[] jrybyArgs = new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)this.hook.getRuntime(), (Object)scenarioResult)};
        this.hook.callMethod("execute", jrybyArgs);
    }

    @Override
    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.eval(tags);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

