/*
 * Decompiled with CFR 0.152.
 */
package cucumber.deps.com.thoughtworks.xstream.converters.enums;

import cucumber.deps.com.thoughtworks.xstream.converters.ConversionException;
import cucumber.deps.com.thoughtworks.xstream.converters.MarshallingContext;
import cucumber.deps.com.thoughtworks.xstream.converters.UnmarshallingContext;
import cucumber.deps.com.thoughtworks.xstream.converters.collections.MapConverter;
import cucumber.deps.com.thoughtworks.xstream.core.util.Fields;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cucumber.deps.com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.EnumMap;

public class EnumMapConverter
extends MapConverter {
    private static final Field typeField;

    public EnumMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return typeField != null && type == EnumMap.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class type = (Class)Fields.read(typeField, source);
        String attributeName = this.mapper().aliasForSystemAttribute("enum-type");
        if (attributeName != null) {
            writer.addAttribute(attributeName, this.mapper().serializedClass(type));
        }
        super.marshal(source, writer, context);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String attributeName = this.mapper().aliasForSystemAttribute("enum-type");
        if (attributeName == null) {
            throw new ConversionException("No EnumType specified for EnumMap");
        }
        Class type = this.mapper().realClass(reader.getAttribute(attributeName));
        EnumMap map = new EnumMap(type);
        this.populateMap(reader, context, map);
        return map;
    }

    static {
        Field assumedTypeField = null;
        try {
            Field[] fields = EnumMap.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != Class.class) continue;
                assumedTypeField = fields[i];
                assumedTypeField.setAccessible(true);
                break;
            }
            if (assumedTypeField == null) {
                throw new ExceptionInInitializerError("Cannot detect key type of EnumMap");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        typeField = assumedTypeField;
    }
}

