/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.jruby;

import cucumber.api.DataTable;
import cucumber.api.PendingException;
import cucumber.api.Scenario;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.jruby.JRubyHookDefinition;
import cucumber.runtime.jruby.JRubySnippet;
import cucumber.runtime.jruby.JRubyStepDefinition;
import cucumber.runtime.jruby.JRubyWorldDefinition;
import cucumber.runtime.jruby.World;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.I18n;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyBackend
implements Backend {
    private static final String DSL = "/cucumber/runtime/jruby/dsl.rb";
    private final SnippetGenerator snippetGenerator = new SnippetGenerator(new JRubySnippet());
    private final ScriptingContainer jruby = new ScriptingContainer();
    private final ResourceLoader resourceLoader;
    private final Set<JRubyWorldDefinition> worldDefinitions = new HashSet<JRubyWorldDefinition>();
    private final RubyModule CucumberRuntimeJRubyWorld;
    private Glue glue;
    private UnreportedStepExecutor unreportedStepExecutor;
    private RubyObject currentWorld;

    public JRubyBackend(ResourceLoader resourceLoader) throws UnsupportedEncodingException {
        this.resourceLoader = resourceLoader;
        this.jruby.put("$backend", (Object)this);
        this.jruby.setClassLoader(this.getClass().getClassLoader());
        try {
            String rubyVersion;
            ResourceBundle bundle = ResourceBundle.getBundle("cucumber-jruby");
            String gemPath = bundle.getString("GEM_PATH");
            if (gemPath != null && !gemPath.isEmpty()) {
                this.jruby.runScriptlet("ENV['GEM_PATH']='" + gemPath + "'");
            }
            if ("1.8".equals(rubyVersion = bundle.getString("RUBY_VERSION"))) {
                this.jruby.setCompatVersion(CompatVersion.RUBY1_8);
            }
            if ("1.9".equals(rubyVersion)) {
                this.jruby.setCompatVersion(CompatVersion.RUBY1_8);
            }
            if ("2.0".equals(rubyVersion)) {
                this.jruby.setCompatVersion(CompatVersion.RUBY2_0);
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        this.jruby.runScriptlet((Reader)new InputStreamReader(this.getClass().getResourceAsStream(DSL), "UTF-8"), DSL);
        Ruby runtime = this.jruby.getProvider().getRuntime();
        RubyModule Cucumber = runtime.getModule("Cucumber");
        RubyModule CucumberRuntime = (RubyModule)Cucumber.const_get((IRubyObject)runtime.newString("Runtime"));
        RubyModule CucumberRuntimeJRuby = (RubyModule)CucumberRuntime.const_get((IRubyObject)runtime.newString("JRuby"));
        this.CucumberRuntimeJRubyWorld = (RubyModule)CucumberRuntimeJRuby.const_get((IRubyObject)runtime.newString("World"));
    }

    @Override
    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        for (String gluePath : gluePaths) {
            for (Resource resource : this.resourceLoader.resources(gluePath, ".rb")) {
                this.runScriptlet(resource);
            }
        }
    }

    @Override
    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
        this.unreportedStepExecutor = executor;
    }

    @Override
    public void buildWorld() {
        this.currentWorld = (RubyObject)JavaEmbedUtils.javaToRuby((Ruby)this.jruby.getProvider().getRuntime(), (Object)new World());
        this.currentWorld.extend(new IRubyObject[]{this.CucumberRuntimeJRubyWorld});
        for (JRubyWorldDefinition definition : this.worldDefinitions) {
            this.currentWorld = definition.execute(this.currentWorld);
        }
    }

    private void runScriptlet(Resource resource) {
        try {
            this.jruby.runScriptlet((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"), resource.getPath());
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    @Override
    public void disposeWorld() {
    }

    @Override
    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    public void registerStepdef(RubyObject stepdefRunner) {
        this.glue.addStepDefinition(new JRubyStepDefinition(this, stepdefRunner));
    }

    public void registerBeforeHook(RubyObject procRunner) {
        this.glue.addBeforeHook(new JRubyHookDefinition(this, new String[0], procRunner));
    }

    public void registerAfterHook(RubyObject procRunner) {
        this.glue.addAfterHook(new JRubyHookDefinition(this, new String[0], procRunner));
    }

    public void registerWorldBlock(RubyObject procRunner) {
        this.worldDefinitions.add(new JRubyWorldDefinition(procRunner));
    }

    public void pending(String reason) throws PendingException {
        throw new PendingException(reason);
    }

    public void runStep(String uri, I18n i18n, String stepKeyword, String stepName, int line, DataTable dataTable, DocString docString) throws Throwable {
        List<DataTableRow> dataTableRows = null;
        if (dataTable != null) {
            dataTableRows = dataTable.getGherkinRows();
        }
        this.unreportedStepExecutor.runUnreportedStep(uri, i18n, stepKeyword, stepName, line, dataTableRows, docString);
    }

    public void executeHook(RubyObject hookRunner, Scenario scenario) {
        IRubyObject[] jrubyArgs = new IRubyObject[]{this.currentWorld, JavaEmbedUtils.javaToRuby((Ruby)hookRunner.getRuntime(), (Object)scenario)};
        hookRunner.callMethod("execute", jrubyArgs);
    }

    void executeStepdef(RubyObject stepdef, I18n i18n, Object[] args) {
        ArrayList<Object> jrubyArgs = new ArrayList<Object>();
        RubyObject jrubyI18n = (RubyObject)JavaEmbedUtils.javaToRuby((Ruby)stepdef.getRuntime(), (Object)i18n);
        this.currentWorld.callMethod("instance_variable_set", new IRubyObject[]{stepdef.getRuntime().newSymbol("@__gherkin_i18n"), jrubyI18n});
        jrubyArgs.add(this.currentWorld);
        for (Object o : args) {
            if (o == null) {
                jrubyArgs.add(null);
                continue;
            }
            if (o instanceof DataTable) {
                jrubyArgs.add(JavaEmbedUtils.javaToRuby((Ruby)stepdef.getRuntime(), (Object)o));
                continue;
            }
            jrubyArgs.add(stepdef.getRuntime().newString((String)o));
        }
        stepdef.callMethod("execute", jrubyArgs.toArray(new IRubyObject[jrubyArgs.size()]));
    }
}

